/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.httpcomponent.httpclient;

import com.aliyun.core.http.HttpClient;
import com.aliyun.core.http.HttpHeader;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.http.ProxyOptions;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.BinaryUtils;
import com.aliyun.core.utils.Context;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.httpcomponent.httpclient.implementation.ApacheAsyncHttpResponse;
import com.aliyun.httpcomponent.httpclient.implementation.StreamRequestProducer;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Timeout;

class ApacheAsyncHttpClient
implements HttpClient {
    private final ClientLogger logger = new ClientLogger(ApacheAsyncHttpClient.class);
    CloseableHttpAsyncClient apacheHttpAsyncClient;
    boolean clientIsStart;

    ApacheAsyncHttpClient(CloseableHttpAsyncClient apacheHttpAsyncClient) {
        this.apacheHttpAsyncClient = apacheHttpAsyncClient;
    }

    public CompletableFuture<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public CompletableFuture<HttpResponse> send(HttpRequest request, Context context) {
        if (!this.clientIsStart) {
            this.clientIsStart = true;
            this.apacheHttpAsyncClient.start();
        }
        return this.sendV1(request, context);
    }

    public void close() {
        if (this.apacheHttpAsyncClient != null) {
            this.apacheHttpAsyncClient.close(CloseMode.GRACEFUL);
        }
    }

    private SimpleHttpRequest toApacheAsyncRequest(HttpRequest request) throws URISyntaxException, ExecutionException, InterruptedException {
        SimpleRequestBuilder apacheRequestBuilder = SimpleRequestBuilder.create((String)request.getHttpMethod().toString()).setUri(request.getUrl().toURI());
        HttpHeaders headers = request.getHeaders();
        for (HttpHeader httpHeader : headers) {
            apacheRequestBuilder.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        switch (request.getHttpMethod()) {
            case GET: 
            case HEAD: 
            case DELETE: {
                return apacheRequestBuilder.build();
            }
        }
        ContentType type = StringUtils.isEmpty((CharSequence)headers.getValue("content-type")) ? ContentType.APPLICATION_FORM_URLENCODED : ContentType.create((String)headers.getValue("content-type"));
        if (request.getBody() != null) {
            apacheRequestBuilder.setBody(BinaryUtils.copyAllBytesFrom((ByteBuffer)((ByteBuffer)request.getBody().get())), type);
        }
        return apacheRequestBuilder.build();
    }

    private CompletableFuture<HttpResponse> sendV1(HttpRequest request, Context context) {
        SimpleHttpRequest apacheRequest;
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        try {
            apacheRequest = this.toApacheAsyncRequest(request);
        }
        catch (InterruptedException | URISyntaxException | ExecutionException e) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'url' must can convert to a valid URI", e));
        }
        apacheRequest.setConfig(new ApacheIndividualRequestBuilder(request).build());
        final CompletableFuture cf = new CompletableFuture();
        Future future = this.apacheHttpAsyncClient.execute(apacheRequest, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse response) {
                cf.complete(response);
            }

            public void failed(Exception ex) {
                cf.completeExceptionally(ex);
            }

            public void cancelled() {
                cf.cancel(true);
            }
        });
        return cf.thenApply(simpleHttpResponse -> new ApacheAsyncHttpResponse(request, (SimpleHttpResponse)simpleHttpResponse));
    }

    private AsyncRequestProducer toApacheRequestProducer(HttpRequest request) throws URISyntaxException {
        SimpleRequestBuilder apacheRequestBuilder = SimpleRequestBuilder.create((String)request.getHttpMethod().toString()).setUri(request.getUrl().toURI());
        HttpHeaders headers = request.getHeaders();
        for (HttpHeader httpHeader : headers) {
            apacheRequestBuilder.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        SimpleHttpRequest simpleHttpRequest = apacheRequestBuilder.build();
        return StreamRequestProducer.create(simpleHttpRequest, request.getStreamBody());
    }

    private CompletableFuture<HttpResponse> sendV2(HttpRequest request, Context context) {
        AsyncRequestProducer apacheRequestProducer;
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        try {
            apacheRequestProducer = this.toApacheRequestProducer(request);
        }
        catch (URISyntaxException e) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'url' must can convert to a valid URI", e));
        }
        final CompletableFuture cf = new CompletableFuture();
        Future future = this.apacheHttpAsyncClient.execute(apacheRequestProducer, (AsyncResponseConsumer)SimpleResponseConsumer.create(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse response) {
                cf.complete(response);
            }

            public void failed(Exception ex) {
                cf.completeExceptionally(ex);
            }

            public void cancelled() {
                cf.cancel(true);
            }
        });
        return cf.thenApply(simpleHttpResponse -> new ApacheAsyncHttpResponse(request, (SimpleHttpResponse)simpleHttpResponse));
    }

    private static final class ApacheIndividualRequestBuilder {
        private final ClientLogger logger = new ClientLogger(ApacheIndividualRequestBuilder.class);
        private final HttpRequest request;
        private final RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        private final Timeout connectTimeout = Timeout.ofSeconds((long)10L);
        private final Timeout responseTimeout = Timeout.ofSeconds((long)20L);
        private final Timeout connectionRequestTimeout = Timeout.ofSeconds((long)30L);

        public ApacheIndividualRequestBuilder(HttpRequest request) {
            this.request = request;
        }

        ApacheIndividualRequestBuilder setConnectTimeout() {
            if (this.request.getConnectTimeout() != null) {
                this.requestConfigBuilder.setConnectTimeout(this.duration2Timeout(this.request.getConnectTimeout()));
            } else {
                this.requestConfigBuilder.setConnectTimeout(this.connectTimeout);
            }
            return this;
        }

        ApacheIndividualRequestBuilder setResponseTimeout() {
            if (this.request.getResponseTimeout() != null) {
                this.requestConfigBuilder.setResponseTimeout(this.duration2Timeout(this.request.getReadTimeout()));
            } else {
                this.requestConfigBuilder.setResponseTimeout(this.responseTimeout);
            }
            return this;
        }

        ApacheIndividualRequestBuilder setConnectionRequestTimeout() {
            this.requestConfigBuilder.setConnectionRequestTimeout(this.connectionRequestTimeout);
            return this;
        }

        ApacheIndividualRequestBuilder setProxy() {
            ProxyOptions proxyOptions = this.request.getProxyOptions();
            Pattern nonProxyHostsPattern = null;
            if (proxyOptions != null) {
                Pattern pattern = nonProxyHostsPattern = StringUtils.isEmpty((CharSequence)proxyOptions.getNonProxyHosts()) ? null : Pattern.compile(proxyOptions.getNonProxyHosts(), 2);
            }
            if (nonProxyHostsPattern != null && !nonProxyHostsPattern.matcher(this.request.getUrl().getHost()).matches()) {
                InetSocketAddress inetSocketAddress = proxyOptions.getAddress();
                this.requestConfigBuilder.setProxy(new HttpHost(proxyOptions.getScheme(), inetSocketAddress.getAddress(), inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
            }
            return this;
        }

        RequestConfig build() {
            this.setConnectTimeout().setResponseTimeout().setConnectionRequestTimeout().setProxy();
            return this.requestConfigBuilder.build();
        }

        private Timeout duration2Timeout(Duration duration) {
            return Timeout.ofMilliseconds((long)duration.toMillis());
        }
    }
}

