/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.httpcomponent.httpclient.implementation;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.utils.BaseUtils;
import com.aliyun.httpcomponent.httpclient.implementation.ApacheHttpResponseBase;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.Header;

public final class ApacheAsyncHttpResponse
extends ApacheHttpResponseBase {
    private SimpleHttpResponse apacheResponse;

    public ApacheAsyncHttpResponse(HttpRequest httpRequest, SimpleHttpResponse apacheResponse) {
        super(httpRequest, apacheResponse.getCode(), ApacheAsyncHttpResponse.toHeaders(apacheResponse));
        this.apacheResponse = apacheResponse;
    }

    public ByteBuffer getBody() {
        return ByteBuffer.wrap(this.getBodyAsByteArray());
    }

    public byte[] getBodyAsByteArray() {
        return this.apacheResponse.getBody().getBodyBytes();
    }

    public String getBodyAsString() {
        return BaseUtils.bomAwareToString((byte[])this.getBodyAsByteArray(), (String)this.getHeaderValue("Content-Type"));
    }

    public String getBodyAsString(Charset charset) {
        return new String(this.getBodyAsByteArray(), charset);
    }

    private static HttpHeaders toHeaders(SimpleHttpResponse response) {
        Header[] apacheHeaders;
        HttpHeaders httpHeaders = new HttpHeaders();
        HashSet<String> nameSet = new HashSet<String>();
        for (Header header : apacheHeaders = response.getHeaders()) {
            nameSet.add(header.getName());
        }
        nameSet.forEach(name -> {
            Header[] entityHeaders = response.getHeaders(name);
            ArrayList<String> values = new ArrayList<String>();
            for (Header entityHeader : entityHeaders) {
                values.add(entityHeader.getValue());
            }
            httpHeaders.set(name, values);
        });
        return httpHeaders;
    }
}

