package com.aliyun.httpcomponent.httpclient.implementation.reactive;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.http.HttpResponse;
import org.apache.hc.core5.http.Header;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ReactiveHttpResponse extends HttpResponse {
    private final int statusCode;
    private final HttpHeaders headers;

    public ReactiveHttpResponse(HttpRequest request, ReactiveApacheHttpResponse apacheResponse) {
        super(request);
        this.statusCode = apacheResponse.getCode();
        this.headers = toHeaders(apacheResponse);
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public ByteBuffer getBody() {
        return null;
    }

    @Override
    public byte[] getBodyAsByteArray() {
        return null;
    }

    @Override
    public String getBodyAsString() {
        return null;
    }

    @Override
    public String getBodyAsString(Charset charset) {
        return null;
    }

    private static HttpHeaders toHeaders(ReactiveApacheHttpResponse response) {
        final HttpHeaders httpHeaders = new HttpHeaders();
        Set<String> nameSet = new HashSet<>();
        Header[] apacheHeaders = response.getHeaders();
        for (Header header : apacheHeaders) {
            nameSet.add(header.getName());
        }
        nameSet.forEach((name) -> {
            Header[] entityHeaders = response.getHeaders(name);
            List<String> values = new ArrayList<>();
            for (Header entityHeader : entityHeaders) {
                values.add(entityHeader.getValue());
            }
            httpHeaders.set(name, values);
        });
        return httpHeaders;
    }
}
