/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.apache.hc.core5.http.impl;

import com.aliyun.apache.hc.core5.http.protocol.HttpProcessor;
import com.aliyun.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import com.aliyun.apache.hc.core5.http.protocol.RequestConnControl;
import com.aliyun.apache.hc.core5.http.protocol.RequestContent;
import com.aliyun.apache.hc.core5.http.protocol.RequestExpectContinue;
import com.aliyun.apache.hc.core5.http.protocol.RequestTargetHost;
import com.aliyun.apache.hc.core5.http.protocol.RequestUserAgent;
import com.aliyun.apache.hc.core5.http.protocol.RequestValidateHost;
import com.aliyun.apache.hc.core5.http.protocol.ResponseConnControl;
import com.aliyun.apache.hc.core5.http.protocol.ResponseContent;
import com.aliyun.apache.hc.core5.http.protocol.ResponseDate;
import com.aliyun.apache.hc.core5.http.protocol.ResponseServer;
import com.aliyun.apache.hc.core5.util.TextUtils;
import com.aliyun.apache.hc.core5.util.VersionInfo;

public final class HttpProcessors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(new ResponseDate(), new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "org.apache.hc.core5", HttpProcessors.class)), new ResponseContent(), new ResponseConnControl()).addAll(new RequestValidateHost());
    }

    public static HttpProcessor server(String serverInfo) {
        return HttpProcessors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return HttpProcessors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(RequestContent.INSTANCE, RequestTargetHost.INSTANCE, RequestConnControl.INSTANCE, new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "org.apache.hc.core5", HttpProcessors.class)), RequestExpectContinue.INSTANCE);
    }

    public static HttpProcessor client(String agentInfo) {
        return HttpProcessors.customClient(agentInfo).build();
    }

    public static HttpProcessor client() {
        return HttpProcessors.customClient(null).build();
    }
}

