package com.aliyun.httpcomponent.httpclient.implementation;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.http.HttpResponse;

abstract class ApacheHttpResponseBase extends HttpResponse {
    private final int statusCode;
    private final HttpHeaders headers;

    ApacheHttpResponseBase(final HttpRequest request, int statusCode, HttpHeaders headers) {
        super(request);
        this.statusCode = statusCode;
        this.headers = headers;
    }

    @Override
    public final int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public final String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    @Override
    public final HttpHeaders getHeaders() {
        return this.headers;
    }
}
