package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.*;
import com.aliyun.auth.credentials.utils.*;
import com.aliyun.core.utils.StringUtils;

public class EnvironmentVariableCredentialProvider implements ICredentialProvider {

    public static EnvironmentVariableCredentialProvider create() {
        return new EnvironmentVariableCredentialProvider();
    }

    @Override
    public ICredential getCredentials() throws CredentialException {
        String accessKeyId = AuthConstant.ENV_ACCESS_KEY_ID;
        String accessKeySecret = AuthConstant.ENV_ACCESS_KEY_SECRET;
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            throw new CredentialException("Environment variable accessKeyId/accessKeySecret cannot be empty");
        }
        return Credential.builder()
                .accessKeyId(accessKeyId)
                .accessKeySecret(accessKeySecret)
                .build();
    }

    @Override
    public void close() {
    }
}
