package com.aliyun.auth.credentials.http;


import com.aliyun.apache.hc.client5.http.ssl.DefaultHostnameVerifier;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class DefaultAuthHostnameVerifier implements HostnameVerifier {
    private boolean ignoreSSLCert = false;
    private static final HostnameVerifier NOOP_INSTANCE = new DefaultAuthHostnameVerifier(true);

    private DefaultAuthHostnameVerifier(boolean ignoreSSLCert) {
        this.ignoreSSLCert = ignoreSSLCert;
    }

    public static HostnameVerifier getInstance(boolean ignoreSSLCert) {
        if (ignoreSSLCert) {
            return NOOP_INSTANCE;
        } else {
            return new DefaultHostnameVerifier();
        }
    }

    @Override
    public boolean verify(String s, SSLSession sslSession) {
        return ignoreSSLCert;
    }
}
