package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.*;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.core.utils.Validate;

import java.util.HashMap;
import java.util.Map;

public class StaticCredentialProvider implements ICredentialProvider {
    private Credential credential;

    private StaticCredentialProvider(Credential credential) {
        this.credential = Validate.notNull(credential, "Credentials must not be null.");
    }

    public static StaticCredentialProvider create(Credential credentials) {
        return new StaticCredentialProvider(credentials);
    }

    public ICredential getCredentials() throws CredentialException {
        return credential;
    }

    @Override
    public void close() {
    }

    @Override
    public String toString() {
        Map<String, Object> fieldMap = new HashMap<>();
        fieldMap.put("credential", credential);
        return StringUtils.toAliString("StaticCredentialsProvider", fieldMap);
    }
}
