/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.OIDCRoleArnCredentialProvider;
import com.aliyun.auth.credentials.provider.RamRoleArnCredentialProvider;
import com.aliyun.auth.credentials.provider.RsaKeyPairCredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.auth.credentials.utils.AuthConstant;
import com.aliyun.auth.credentials.utils.AuthUtils;
import com.aliyun.auth.credentials.utils.ProfileUtils;
import com.aliyun.core.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ProfileCredentialProvider
implements ICredentialProvider {
    private static volatile Map<String, Map<String, String>> ini;
    private final String profileFile;
    private final String clientType;
    private final ICredentialProvider credentialProvider;
    private final boolean asyncCredentialUpdateEnabled;

    private ProfileCredentialProvider(Builder builder) {
        Map<String, Map<String, String>> ini;
        this.profileFile = builder.profileFile == null ? AuthConstant.DEFAULT_CREDENTIALS_FILE_PATH : builder.profileFile;
        this.clientType = builder.clientType == null ? "default" : builder.clientType;
        this.asyncCredentialUpdateEnabled = builder.asyncCredentialUpdateEnabled;
        if (this.profileFile.length() == 0) {
            throw new CredentialException("The specified credentials file is empty.");
        }
        try {
            ini = ProfileCredentialProvider.getIni(this.profileFile);
        }
        catch (IOException e) {
            throw new CredentialException("The specified credentials file is not exist.");
        }
        Map<String, Map<String, String>> client = this.loadIni(ini);
        Map<String, String> clientConfig = client.get(this.clientType);
        if (clientConfig == null) {
            throw new CredentialException("Client is not open in the specified credentials file.");
        }
        this.credentialProvider = this.createCredentialProvider(clientConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProfileCredentialProvider create() {
        return ProfileCredentialProvider.builder().build();
    }

    public static ProfileCredentialProvider create(String clientType) {
        return ProfileCredentialProvider.builder().clientType(clientType).build();
    }

    @Override
    public ICredential getCredentials() throws CredentialException {
        return this.credentialProvider.getCredentials();
    }

    public void close() {
    }

    private static Map<String, Map<String, String>> getIni(String profileFile) throws IOException {
        if (null == ini) {
            ini = ProfileUtils.parseFile(profileFile);
        }
        return ini;
    }

    private Map<String, Map<String, String>> loadIni(Map<String, Map<String, String>> ini) {
        HashMap<String, Map<String, String>> client = new HashMap<String, Map<String, String>>(16);
        for (Map.Entry<String, Map<String, String>> clientType : ini.entrySet()) {
            String enable = clientType.getValue().get("enable");
            if (!Boolean.parseBoolean(enable)) continue;
            HashMap<String, String> clientConfig = new HashMap<String, String>(16);
            for (Map.Entry<String, String> enabledClient : clientType.getValue().entrySet()) {
                clientConfig.put(enabledClient.getKey(), enabledClient.getValue());
            }
            client.put(clientType.getKey(), clientConfig);
        }
        return client;
    }

    private ICredentialProvider createCredentialProvider(Map<String, String> clientConfig) {
        String configType = clientConfig.get("type");
        if (StringUtils.isEmpty((CharSequence)configType)) {
            throw new CredentialException("The configured client type is empty.");
        }
        if ("ram_role_arn".equals(configType)) {
            return this.getSTSAssumeRoleSessionCredentialProvider(clientConfig);
        }
        if ("rsa_key_pair".equals(configType)) {
            return this.getSTSGetSessionAccessKeyCredentialProvider(clientConfig);
        }
        if ("ecs_ram_role".equals(configType)) {
            return this.getInstanceProfileCredentialProvider(clientConfig);
        }
        if ("oidc_role_arn".equals(configType)) {
            return this.getSTSOIDCRoleSessionCredentials(clientConfig);
        }
        String accessKeyId = clientConfig.get("access_key_id");
        String accessKeySecret = clientConfig.get("access_key_secret");
        if (StringUtils.isEmpty((CharSequence)accessKeyId) || StringUtils.isEmpty((CharSequence)accessKeySecret)) {
            throw new CredentialException("The configured access_key_id or access_key_secret is empty");
        }
        return StaticCredentialProvider.create(Credential.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).build());
    }

    private ICredentialProvider getSTSAssumeRoleSessionCredentialProvider(Map<String, String> clientConfig) {
        String accessKeyId = clientConfig.get("access_key_id");
        String accessKeySecret = clientConfig.get("access_key_secret");
        String roleSessionName = clientConfig.get("role_session_name");
        String roleArn = clientConfig.get("role_arn");
        String regionId = clientConfig.get("region_id");
        String policy = clientConfig.get("policy");
        if (StringUtils.isEmpty((CharSequence)accessKeyId) || StringUtils.isEmpty((CharSequence)accessKeySecret)) {
            throw new CredentialException("The configured access_key_id or access_key_secret is empty.");
        }
        if (StringUtils.isEmpty((CharSequence)roleSessionName) || StringUtils.isEmpty((CharSequence)roleArn)) {
            throw new CredentialException("The configured role_session_name or role_arn is empty.");
        }
        return ((RamRoleArnCredentialProvider.Builder)RamRoleArnCredentialProvider.builder().roleSessionName(roleSessionName).roleArn(roleArn).regionId(regionId).policy(policy).asyncCredentialUpdateEnabled(this.asyncCredentialUpdateEnabled)).credential(Credential.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).build()).build();
    }

    private ICredentialProvider getSTSOIDCRoleSessionCredentials(Map<String, String> clientConfig) {
        String roleSessionName = clientConfig.get("role_session_name");
        String roleArn = clientConfig.get("role_arn");
        String OIDCProviderArn = clientConfig.get("oidc_provider_arn");
        String OIDCTokenFilePath = clientConfig.get("oidc_token_file_path");
        String policy = clientConfig.get("policy");
        if (StringUtils.isEmpty((CharSequence)roleArn)) {
            throw new CredentialException("The configured role_arn is empty.");
        }
        if (StringUtils.isEmpty((CharSequence)OIDCProviderArn)) {
            throw new CredentialException("The configured oidc_provider_arn is empty.");
        }
        if (StringUtils.isEmpty((CharSequence)OIDCTokenFilePath)) {
            throw new CredentialException("The configured oidc_token_file_path is empty.");
        }
        return OIDCRoleArnCredentialProvider.builder().roleArn(roleArn).roleSessionName(roleSessionName).oidcProviderArn(OIDCProviderArn).oidcTokenFilePath(OIDCTokenFilePath).policy(policy).build();
    }

    public ICredentialProvider getSTSGetSessionAccessKeyCredentialProvider(Map<String, String> clientConfig) {
        String publicKeyId = clientConfig.get("public_key_id");
        String privateKeyFile = clientConfig.get("private_key_file");
        if (StringUtils.isEmpty((CharSequence)privateKeyFile)) {
            throw new CredentialException("The configured private_key_file is empty.");
        }
        String privateKey = AuthUtils.getPrivateKey(privateKeyFile);
        if (StringUtils.isEmpty((CharSequence)publicKeyId) || StringUtils.isEmpty((CharSequence)privateKey)) {
            throw new CredentialException("The configured public_key_id or private_key_file content is empty.");
        }
        return ((RsaKeyPairCredentialProvider.Builder)RsaKeyPairCredentialProvider.builder().asyncCredentialUpdateEnabled(this.asyncCredentialUpdateEnabled)).credential(Credential.builder().accessKeyId(publicKeyId).accessKeySecret(privateKey).build()).build();
    }

    private ICredentialProvider getInstanceProfileCredentialProvider(Map<String, String> clientConfig) {
        String roleName = clientConfig.get("role_name");
        if (StringUtils.isEmpty((CharSequence)roleName)) {
            throw new CredentialException("The configured role_name is empty.");
        }
        return ((EcsRamRoleCredentialProvider.Builder)EcsRamRoleCredentialProvider.builder().asyncCredentialUpdateEnabled(this.asyncCredentialUpdateEnabled)).roleName(roleName).build();
    }

    static final class Builder {
        private String profileFile = AuthConstant.CREDENTIALS_FILE_PATH;
        private String clientType = AuthConstant.CLIENT_TYPE;
        private boolean asyncCredentialUpdateEnabled = false;

        Builder() {
        }

        public Builder profileFile(String profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public Builder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public Builder asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return this;
        }

        public ProfileCredentialProvider build() {
            return new ProfileCredentialProvider(this);
        }
    }
}

