package com.aliyun.core.utils;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.*;

public class XmlUtil {
    public static Map<String, Object> deserializeXml(String xmlStr) throws DocumentException {
        if (StringUtils.isEmpty(xmlStr)) {
            return null;
        }
        return DomToMap(DocumentHelper.parseText(xmlStr));
    }

    public static String serializeXml(Map xmlMap, String rootName) {
        if (xmlMap == null) {
            return null;
        }
        return MapToDom(xmlMap, rootName).asXML();
    }

    private static Map<String, Object> DomToMap(Document document) {
        Element rootElement = document.getRootElement();
        Map<String, Object> map = new HashMap();
        ElementToMap(rootElement, map);
        return map;
    }

    private static Object ElementToMap(Element element, Map<String, Object> map) {
        List<Element> elements = element.elements();
        if (elements.size() == 0) {
            if (null != map) {
                map.put(element.getName(), element.getTextTrim());
            }
            return element.getTextTrim();
        } else {
            Map<String, Object> map2 = new HashMap();
            if (null != map) {
                map.put(element.getName(), map2);
            }
            String repetitionName = "";
            for (Element element2 : elements) {
                if (repetitionName.equals(element2.getName())) {
                    List list = (List) map2.get(repetitionName);
                    list.add(ElementToMap(element2, null));
                } else if (map2.containsKey(element2.getName())) {
                    repetitionName = element2.getName();
                    Object remove = map2.remove(repetitionName);
                    List list = new ArrayList();
                    list.add(remove);
                    list.add(ElementToMap(element2, null));
                    map2.put(element2.getName(), list);
                } else {
                    ElementToMap(element2, map2);
                }
            }
            return map2;
        }
    }

    public static Document MapToDom(Map map, String rootName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootName);
        MapToElement(root, map);
        return document;
    }

    private static void MapToElement(Element root, Map<String, ?> map) {
        if (null == map) {
            return;
        }
        for (Map.Entry<String, ?> en : map.entrySet()) {
            if (null == en.getValue()) {
                continue;
            }
            if (en.getValue() instanceof Map) {
                Element element = root.addElement(en.getKey());
                MapToElement(element, (Map<String, ?>) en.getValue());
            } else if (en.getValue() instanceof List) {
                List<?> value = (List<?>) en.getValue();
                for (Object obj : value) {
                    Element element = root.addElement(en.getKey());
                    if (obj instanceof Map) {
                        MapToElement(element, (Map<String, ?>) obj);
                    } else {
                        element.add(DocumentHelper.createText(obj.toString()));
                    }
                }
            } else {
                Element element = root.addElement(en.getKey());
                element.add(DocumentHelper.createText(en.getValue().toString()));
            }
        }
        return;
    }

    public static void main(String[] args) {
        Map<String, String> map = new HashMap<>();
        map.put("test1", "1");
        map.put("test2", "2");
        System.out.println(XmlUtil.serializeXml(map, "test"));
    }
}
