package com.aliyun.core.http;

import com.aliyun.core.utils.ClientOptions;
import com.aliyun.core.utils.HttpClientOptions;

import java.util.Iterator;
import java.util.ServiceLoader;

public final class HttpClientProviders {
    private static final String CANNOT_FIND_HTTP_CLIENT = "A request was made to load the default HttpClient provider.";
    private static HttpClientProvider defaultProvider;

    static {
        ServiceLoader<HttpClientProvider> serviceLoader = ServiceLoader.load(HttpClientProvider.class);
        Iterator<HttpClientProvider> it = serviceLoader.iterator();
        if (it.hasNext()) {
            defaultProvider = it.next();
        }
    }

    private HttpClientProviders() {
        // no-op
    }

    public static HttpClient createInstance() {
        return createInstance(null);
    }

    public static HttpClient createInstance(ClientOptions clientOptions) {
        if (defaultProvider == null) {
            throw new IllegalStateException(CANNOT_FIND_HTTP_CLIENT);
        }

        if (clientOptions instanceof HttpClientOptions) {
            return defaultProvider.createInstance((HttpClientOptions) clientOptions);
        }

        return defaultProvider.createInstance();
    }
}
