package com.aliyun.core.http;

import com.aliyun.core.utils.Context;
import com.aliyun.core.utils.HttpClientOptions;
import com.aliyun.core.utils.SdkAutoCloseable;

import java.util.concurrent.CompletableFuture;

public interface HttpClient extends SdkAutoCloseable {
    CompletableFuture<HttpResponse> send(HttpRequest request);

    default CompletableFuture<HttpResponse> send(HttpRequest request, Context context) {
        return send(request);
    }

    static HttpClient createDefault() {
        return createDefault(null);
    }

    static HttpClient createDefault(HttpClientOptions clientOptions) {
        return HttpClientProviders.createInstance(clientOptions);
    }
}
