package com.aliyun.core.utils;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class UnixTime {
    private final OffsetDateTime dateTime;

    public UnixTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public UnixTime(long unixSeconds) {
        this.dateTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond(unixSeconds), ZoneOffset.UTC);
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    @Override
    public String toString() {
        return String.valueOf(dateTime.toEpochSecond());
    }

    @Override
    public int hashCode() {
        return this.dateTime.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnixTime)) {
            return false;
        }
        UnixTime rhs = (UnixTime) obj;
        return this.dateTime.equals(rhs.getDateTime());
    }
}
