/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.core.utils;

import com.aliyun.core.logging.ClientLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class IOUtils {
    private static final ClientLogger DEFAULT_LOGGER = new ClientLogger(IOUtils.class);
    private static final int BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] b = new byte[4096];
            int n = 0;
            while ((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static String toUtf8String(InputStream is) throws IOException {
        return new String(IOUtils.toByteArray(is), StandardCharsets.UTF_8);
    }

    public static void closeQuietly(AutoCloseable is, ClientLogger log) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception ex) {
                ClientLogger logger = log == null ? DEFAULT_LOGGER : log;
                logger.verbose("Ignore failure in closing the Closeable", ex);
            }
        }
    }

    public static void closeIfCloseable(Object maybeCloseable, ClientLogger log) {
        if (maybeCloseable instanceof AutoCloseable) {
            IOUtils.closeQuietly((AutoCloseable)maybeCloseable, log);
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IOUtils.copy(in, out, Long.MAX_VALUE);
    }

    public static long copy(InputStream in, OutputStream out, long readLimit) throws IOException {
        byte[] buf = new byte[4096];
        long count = 0L;
        int n = 0;
        while ((n = in.read(buf)) > -1) {
            out.write(buf, 0, n);
            if ((count += (long)n) < readLimit) continue;
            throw new IOException("Read limit exceeded: " + readLimit);
        }
        return count;
    }

    public static void drainInputStream(InputStream in) {
        try {
            while (in.read() != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void markStreamWithMaxReadLimit(InputStream s) {
        if (s.markSupported()) {
            s.mark(131072);
        }
    }
}

