/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.arms.model.v20190808;

import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.arms.Endpoint;

/**
 * @author auto create
 * @version 
 */
public class ListAlertTemplatesRequest extends RpcAcsRequest<ListAlertTemplatesResponse> {
	   

	private String alertProvider;

	private String templateProvider;

	private String type;

	private String labels;

	private String name;

	private Boolean status;
	public ListAlertTemplatesRequest() {
		super("ARMS", "2019-08-08", "ListAlertTemplates");
		setMethod(MethodType.POST);
		try {
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointMap").set(this, Endpoint.endpointMap);
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointRegional").set(this, Endpoint.endpointRegionalType);
		} catch (Exception e) {}
	}

	public String getAlertProvider() {
		return this.alertProvider;
	}

	public void setAlertProvider(String alertProvider) {
		this.alertProvider = alertProvider;
		if(alertProvider != null){
			putQueryParameter("AlertProvider", alertProvider);
		}
	}

	public String getTemplateProvider() {
		return this.templateProvider;
	}

	public void setTemplateProvider(String templateProvider) {
		this.templateProvider = templateProvider;
		if(templateProvider != null){
			putQueryParameter("TemplateProvider", templateProvider);
		}
	}

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
		if(type != null){
			putQueryParameter("Type", type);
		}
	}

	public String getLabels() {
		return this.labels;
	}

	public void setLabels(String labels) {
		this.labels = labels;
		if(labels != null){
			putQueryParameter("Labels", labels);
		}
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
		if(name != null){
			putQueryParameter("Name", name);
		}
	}

	public Boolean getStatus() {
		return this.status;
	}

	public void setStatus(Boolean status) {
		this.status = status;
		if(status != null){
			putQueryParameter("Status", status.toString());
		}
	}

	@Override
	public Class<ListAlertTemplatesResponse> getResponseClass() {
		return ListAlertTemplatesResponse.class;
	}

}
