/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs;

import com.aliyuncs.AcsResponse;
import com.aliyuncs.auth.AcsURLEncoder;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.ISignatureComposer;
import com.aliyuncs.auth.ISigner;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.regions.ProductDomain;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AcsRequest<T extends AcsResponse>
extends HttpRequest {
    private String version = null;
    private String product = null;
    private String actionName = null;
    private String regionId = null;
    private FormatType acceptFormat = null;
    protected ISignatureComposer composer = null;
    private ProtocolType protocol = ProtocolType.HTTP;
    private Map<String, String> queryParameters = new HashMap<String, String>();

    public AcsRequest(String product) {
        super(null);
        this.headers.put("x-sdk-client", "Java/2.0.0");
        this.product = product;
    }

    public AcsRequest(String product, String version) {
        super(null);
        this.product = product;
        this.setVersion(version);
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getProduct() {
        return this.product;
    }

    public ProtocolType getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolType protocol) {
        this.protocol = protocol;
    }

    public Map<String, String> getQueryParameters() {
        return Collections.unmodifiableMap(this.queryParameters);
    }

    protected void putQueryParameter(String name, String value) {
        this.setParameter(this.queryParameters, name, value);
    }

    protected void setParameter(Map<String, String> map, String name, String value) {
        if (null == name) {
            return;
        }
        map.put(name, value);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public FormatType getAcceptFormat() {
        return this.acceptFormat;
    }

    public void setAcceptFormat(FormatType acceptFormat) {
        this.acceptFormat = acceptFormat;
        this.putHeaderParameter("Accept", FormatType.mapFormatToAccept(acceptFormat));
    }

    public static String concatQueryString(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (null == parameters) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder("");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            urlBuilder.append(AcsURLEncoder.encode(key));
            if (val != null) {
                urlBuilder.append("=").append(AcsURLEncoder.encode(val));
            }
            urlBuilder.append("&");
        }
        int strIndex = urlBuilder.length();
        if (parameters.size() > 0) {
            urlBuilder.deleteCharAt(strIndex - 1);
        }
        return urlBuilder.toString();
    }

    public abstract HttpRequest signRequest(ISigner var1, Credential var2, FormatType var3, ProductDomain var4) throws InvalidKeyException, IllegalStateException, UnsupportedEncodingException, NoSuchAlgorithmException;

    public abstract String composeUrl(String var1, Map<String, String> var2) throws UnsupportedEncodingException;

    public abstract Class<T> getResponseClass();

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }
}

