/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.reader;

import com.aliyuncs.reader.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonReader
implements Reader {
    private static final Object OBJECT_END = new Object();
    private static final Object ARRAY_END = new Object();
    private static final Object COLON = new Object();
    private static final Object COMMA = new Object();
    public static final int FIRST = 0;
    public static final int CURRENT = 1;
    public static final int NEXT = 2;
    private static Map<Character, Character> escapes = new HashMap<Character, Character>();
    private CharacterIterator it;
    private char c;
    private Object token;
    private StringBuffer buf = new StringBuffer();
    private Map<String, String> map = new HashMap<String, String>();

    @Override
    public Map<String, String> read(String response, String endpoint) {
        return this.read(new StringCharacterIterator(response), endpoint, 0);
    }

    public Map<String, String> read(CharacterIterator ci, String endpoint, int start) {
        this.it = ci;
        switch (start) {
            case 0: {
                this.c = this.it.first();
                break;
            }
            case 1: {
                this.c = this.it.current();
                break;
            }
            case 2: {
                this.c = this.it.next();
            }
        }
        this.readJson(endpoint);
        return this.map;
    }

    private Object readJson(String baseKey) {
        this.skipWhiteSpace();
        char ch = this.c;
        this.next();
        switch (ch) {
            case '\"': {
                this.token = this.string();
                break;
            }
            case '[': {
                if (this.c == '\"') {
                    this.list(baseKey);
                    break;
                }
                this.array(baseKey);
                break;
            }
            case ']': {
                this.token = ARRAY_END;
                break;
            }
            case ',': {
                this.token = COMMA;
                break;
            }
            case '{': {
                this.object(baseKey);
                break;
            }
            case '}': {
                this.token = OBJECT_END;
                break;
            }
            case ':': {
                this.token = COLON;
                break;
            }
            case 't': {
                this.next();
                this.next();
                this.next();
                this.token = Boolean.TRUE;
                break;
            }
            case 'f': {
                this.next();
                this.next();
                this.next();
                this.next();
                this.token = Boolean.FALSE;
                break;
            }
            case 'n': {
                this.next();
                this.next();
                this.next();
                this.token = null;
                break;
            }
            default: {
                this.c = this.it.previous();
                if (!Character.isDigit(this.c) && this.c != '-') break;
                this.token = this.number();
            }
        }
        return this.token;
    }

    private void object(String baseKey) {
        String key = baseKey + "." + this.readJson(baseKey);
        while (this.token != OBJECT_END) {
            this.readJson(key);
            if (this.token == OBJECT_END) continue;
            Object object = this.readJson(key);
            if (object instanceof String || object instanceof Number) {
                this.map.put(key, String.valueOf(object));
            }
            if (this.readJson(key) != COMMA) continue;
            key = String.valueOf(this.readJson(key));
            key = baseKey + "." + key;
        }
    }

    private void list(String baseKey) {
        Object value = this.readJson(baseKey);
        int index = 0;
        while (this.token != ARRAY_END) {
            String key = JsonReader.trimFromLast(baseKey, ".") + "[" + index++ + "]";
            this.map.put(key, String.valueOf(value));
            if (this.readJson(baseKey) != COMMA) continue;
            value = this.readJson(baseKey);
        }
        this.map.put(JsonReader.trimFromLast(baseKey, ".") + ".Length", String.valueOf(index));
    }

    private void array(String baseKey) {
        int index = 0;
        String preKey = baseKey.substring(0, baseKey.lastIndexOf("."));
        String key = preKey + "[" + index + "]";
        Object value = this.readJson(key);
        while (this.token != ARRAY_END) {
            this.map.put(preKey + ".Length", String.valueOf(index + 1));
            if (value instanceof String) {
                this.map.put(key, String.valueOf(value));
            }
            if (this.readJson(baseKey) != COMMA) continue;
            key = preKey + "[" + ++index + "]";
            value = this.readJson(key);
        }
    }

    private Object number() {
        int length = 0;
        boolean isFloatingPoint = false;
        this.buf.setLength(0);
        if (this.c == '-') {
            this.add();
        }
        length += this.addDigits();
        if (this.c == '.') {
            this.add();
            length += this.addDigits();
            isFloatingPoint = true;
        }
        if (this.c == 'e' || this.c == 'E') {
            this.add();
            if (this.c == '+' || this.c == '-') {
                this.add();
            }
            this.addDigits();
            isFloatingPoint = true;
        }
        String s = this.buf.toString();
        return isFloatingPoint ? (Number)(length < 17 ? Double.valueOf(s) : new BigDecimal(s)) : (Number)(length < 19 ? Long.valueOf(s) : new BigInteger(s));
    }

    private int addDigits() {
        int ret = 0;
        while (Character.isDigit(this.c)) {
            this.add();
            ++ret;
        }
        return ret;
    }

    private char next() {
        this.c = this.it.next();
        return this.c;
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.c)) {
            this.next();
        }
    }

    private Object string() {
        this.buf.setLength(0);
        while (this.c != '\"') {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Character value = escapes.get(Character.valueOf(this.c));
                if (value == null) continue;
                this.add(value.charValue());
                continue;
            }
            this.add();
        }
        this.next();
        return this.buf.toString();
    }

    private void add(char cc) {
        this.buf.append(cc);
        this.next();
    }

    private void add() {
        this.add(this.c);
    }

    private char unicode() {
        int value = 0;
        block5: for (int i = 0; i < 4; ++i) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + this.c - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + this.c - 107;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + this.c - 75;
                }
            }
        }
        return (char)value;
    }

    public static String trimFromLast(String str, String stripString) {
        int pos = str.lastIndexOf(stripString);
        if (pos > -1) {
            return str.substring(0, pos);
        }
        return str;
    }

    static {
        escapes.put(Character.valueOf('\"'), Character.valueOf('\"'));
        escapes.put(Character.valueOf('\\'), Character.valueOf('\\'));
        escapes.put(Character.valueOf('/'), Character.valueOf('/'));
        escapes.put(Character.valueOf('b'), Character.valueOf('\b'));
        escapes.put(Character.valueOf('f'), Character.valueOf('\f'));
        escapes.put(Character.valueOf('n'), Character.valueOf('\n'));
        escapes.put(Character.valueOf('r'), Character.valueOf('\r'));
        escapes.put(Character.valueOf('t'), Character.valueOf('\t'));
    }
}

