/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.exceptions;

import com.aliyuncs.exceptions.ErrorType;
import java.util.Map;

public class ClientException
extends Exception {
    private static final long serialVersionUID = 534996425110290578L;
    private String requestId;
    private String errCode;
    private String errMsg;
    private ErrorType errorType;
    private String errorDescription;
    private Map<String, Object> accessDeniedDetail;

    public ClientException(String errorCode, String errorMessage, String requestId, String errorDescription, Map<String, Object> accessDeniedDetail) {
        this(errorCode, errorMessage);
        this.setErrorDescription(errorDescription);
        this.setRequestId(requestId);
        this.setAccessDeniedDetail(accessDeniedDetail);
    }

    public ClientException(String errorCode, String errorMessage, String requestId, String errorDescription) {
        this(errorCode, errorMessage);
        this.setErrorDescription(errorDescription);
        this.setRequestId(requestId);
    }

    public ClientException(String errCode, String errMsg, String requestId) {
        this(errCode, errMsg);
        this.requestId = requestId;
        this.setErrorType(ErrorType.Client);
    }

    public ClientException(String errCode, String errMsg, Throwable cause) {
        super(errCode + " : " + errMsg, cause);
        this.errCode = errCode;
        this.errMsg = errMsg;
        this.setErrorType(ErrorType.Client);
    }

    public ClientException(String errCode, String errMsg) {
        super(errCode + " : " + errMsg);
        this.errCode = errCode;
        this.errMsg = errMsg;
        this.setErrorType(ErrorType.Client);
    }

    public ClientException(String message) {
        super(message);
        this.setErrorType(ErrorType.Client);
    }

    public ClientException(Throwable cause) {
        super(cause);
        this.setErrorType(ErrorType.Client);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public Map<String, Object> getAccessDeniedDetail() {
        return this.accessDeniedDetail;
    }

    public void setAccessDeniedDetail(Map<String, Object> accessDeniedDetail) {
        this.accessDeniedDetail = accessDeniedDetail;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + (null == this.getRequestId() ? "" : "\r\nRequestId : " + this.getRequestId()) + (null == this.getErrorDescription() ? "" : "\r\nDescription : " + this.getErrorDescription());
    }
}

