/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.BasicCredentials;
import com.aliyuncs.auth.BasicSessionCredentials;
import com.aliyuncs.auth.StaticCredentialsProvider;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.utils.AuthUtils;
import com.aliyuncs.utils.StringUtils;

public class STSAssumeRoleSessionCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    private String roleArn;
    public long assumeRoleRound = 0L;
    private IAcsClient stsClient;
    private String roleSessionName;
    private long roleSessionDurationSeconds;
    private String policy;
    private String externalId;
    private BasicSessionCredentials credentials = null;
    private int connectTimeout;
    private int readTimeout;
    private String stsEndpoint;

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentials longLivedCredentials, String roleArn, IClientProfile clientProfile) {
        this(new StaticCredentialsProvider(longLivedCredentials), roleArn, clientProfile);
    }

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentialsProvider longLivedCredentialsProvider, String roleArn, IClientProfile clientProfile) {
        if (roleArn == null) {
            throw new NullPointerException("You must specify a value for roleArn.");
        }
        this.roleArn = roleArn;
        this.roleSessionName = STSAssumeRoleSessionCredentialsProvider.getNewRoleSessionName();
        this.stsClient = new DefaultAcsClient(clientProfile, longLivedCredentialsProvider);
        this.roleSessionDurationSeconds = 3600L;
        this.connectTimeout = 5000;
        this.readTimeout = 10000;
    }

    public STSAssumeRoleSessionCredentialsProvider(String accessKeyId, String accessKeySecret, String roleSessionName, String roleArn, String regionId) {
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
        DefaultProfile profile = DefaultProfile.getProfile(regionId, accessKeyId, accessKeySecret);
        this.stsClient = new DefaultAcsClient(profile);
        this.roleSessionDurationSeconds = 3600L;
        this.connectTimeout = 5000;
        this.readTimeout = 10000;
    }

    public STSAssumeRoleSessionCredentialsProvider(String accessKeyId, String accessKeySecret, String roleSessionName, String roleArn, String regionId, String policy) {
        this(accessKeyId, accessKeySecret, roleSessionName, roleArn, regionId);
        this.policy = policy;
    }

    public static String getNewRoleSessionName() {
        return "aliyun-java-sdk-" + System.currentTimeMillis();
    }

    public STSAssumeRoleSessionCredentialsProvider withRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withRoleSessionDurationSeconds(long roleSessionDurationSeconds) {
        if (roleSessionDurationSeconds < 900L) {
            throw new IllegalArgumentException("Assume Role session duration should be in the range of 15min - max");
        }
        this.roleSessionDurationSeconds = roleSessionDurationSeconds;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withSTSClient(IAcsClient client) {
        this.stsClient = client;
        return this;
    }

    private STSAssumeRoleSessionCredentialsProvider(Builder builder) {
        String prefix;
        this.roleSessionName = builder.roleSessionName == null ? (!StringUtils.isEmpty(AuthUtils.getEnvironmentRoleSessionName()) ? AuthUtils.getEnvironmentRoleSessionName() : STSAssumeRoleSessionCredentialsProvider.getNewRoleSessionName()) : builder.roleSessionName;
        long l = this.roleSessionDurationSeconds = builder.durationSeconds == null ? 3600L : (long)builder.durationSeconds.intValue();
        if (this.roleSessionDurationSeconds < 900L) {
            throw new IllegalArgumentException("Session duration should be in the range of 900s - max session duration.");
        }
        String string = this.roleArn = builder.roleArn == null ? AuthUtils.getEnvironmentRoleArn() : builder.roleArn;
        if (StringUtils.isEmpty(this.roleArn)) {
            throw new IllegalArgumentException("RoleArn or environment variable ALIBABA_CLOUD_ROLE_ARN cannot be empty.");
        }
        this.policy = builder.policy;
        this.externalId = builder.externalId;
        this.connectTimeout = builder.connectionTimeout == null ? 5000 : builder.connectionTimeout;
        int n = this.readTimeout = builder.readTimeout == null ? 10000 : builder.readTimeout;
        String string2 = builder.enableVpc != null ? (builder.enableVpc.booleanValue() ? "sts-vpc" : "sts") : (prefix = AuthUtils.isEnableVpcEndpoint() ? "sts-vpc" : "sts");
        this.stsEndpoint = !StringUtils.isEmpty(builder.stsRegionId) ? String.format("%s.%s.aliyuncs.com", prefix, builder.stsRegionId) : (!StringUtils.isEmpty(AuthUtils.getEnvironmentSTSRegion()) ? String.format("%s.%s.aliyuncs.com", prefix, AuthUtils.getEnvironmentSTSRegion()) : "sts.aliyuncs.com");
        DefaultProfile profile = DefaultProfile.getProfile(builder.stsRegionId);
        if (null != builder.credentialsProvider) {
            this.stsClient = new DefaultAcsClient((IClientProfile)profile, builder.credentialsProvider);
        } else if (!StringUtils.isEmpty(builder.securityToken)) {
            StaticCredentialsProvider credentialsProvider = new StaticCredentialsProvider(new BasicSessionCredentials(builder.accessKeyId, builder.accessKeySecret, builder.securityToken));
            this.stsClient = new DefaultAcsClient((IClientProfile)profile, credentialsProvider);
        } else {
            StaticCredentialsProvider credentialsProvider = new StaticCredentialsProvider(new BasicCredentials(builder.accessKeyId, builder.accessKeySecret));
            this.stsClient = new DefaultAcsClient((IClientProfile)profile, credentialsProvider);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException, ServerException {
        if (this.credentials == null || this.credentials.willSoonExpire()) {
            this.credentials = this.getNewSessionCredentials();
        }
        return this.credentials;
    }

    private BasicSessionCredentials getNewSessionCredentials() throws ClientException, ServerException {
        ++this.assumeRoleRound;
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest();
        assumeRoleRequest.setRoleArn(this.roleArn);
        assumeRoleRequest.setRoleSessionName(this.roleSessionName);
        assumeRoleRequest.setDurationSeconds(this.roleSessionDurationSeconds);
        assumeRoleRequest.setSysConnectTimeout(this.connectTimeout);
        assumeRoleRequest.setSysReadTimeout(this.readTimeout);
        if (!StringUtils.isEmpty(this.stsEndpoint)) {
            assumeRoleRequest.setSysEndpoint(this.stsEndpoint);
        }
        if (null != this.policy) {
            assumeRoleRequest.setPolicy(this.policy);
        }
        if (null != this.externalId) {
            assumeRoleRequest.setExternalId(this.externalId);
        }
        AssumeRoleResponse response = this.stsClient.getAcsResponse(assumeRoleRequest);
        return new BasicSessionCredentials(response.getCredentials().getAccessKeyId(), response.getCredentials().getAccessKeySecret(), response.getCredentials().getSecurityToken(), this.roleSessionDurationSeconds);
    }

    public static final class Builder {
        private String roleSessionName;
        private Integer durationSeconds;
        private String roleArn;
        private String policy;
        private Integer connectionTimeout;
        private Integer readTimeout;
        private String stsRegionId;
        private Boolean enableVpc;
        private String accessKeyId;
        private String accessKeySecret;
        private String securityToken;
        private AlibabaCloudCredentialsProvider credentialsProvider;
        private String externalId;

        public Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        public Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder stsRegionId(String stsRegionId) {
            this.stsRegionId = stsRegionId;
            return this;
        }

        public Builder enableVpc(Boolean enableVpc) {
            this.enableVpc = enableVpc;
            return this;
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder accessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        public Builder credentialsProvider(AlibabaCloudCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public STSAssumeRoleSessionCredentialsProvider build() {
            return new STSAssumeRoleSessionCredentialsProvider(this);
        }
    }
}

