/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.BasicCredentials;
import com.aliyuncs.auth.BasicSessionCredentials;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.utils.AuthUtils;
import com.aliyuncs.utils.StringUtils;

public class SystemPropertiesCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException {
        if (!"default".equals(AuthUtils.getClientType())) {
            return null;
        }
        String accessKeyId = System.getProperty("alibabacloud.accessKeyId");
        String accessKeySecret = System.getProperty("alibabacloud.accessKeySecret");
        if (!StringUtils.isEmpty(System.getProperty("alibabacloud.accessKeyIdSecret"))) {
            accessKeySecret = System.getProperty("alibabacloud.accessKeyIdSecret");
        }
        String securityToken = System.getProperty("alibabacloud.sessionToken");
        if (StringUtils.isEmpty(accessKeyId)) {
            throw new ClientException("System property alibabacloud.accessKeyId cannot be empty.");
        }
        if (StringUtils.isEmpty(accessKeySecret)) {
            throw new ClientException("System property alibabacloud.accessKeySecret cannot be empty.");
        }
        if (!StringUtils.isEmpty(securityToken)) {
            return new BasicSessionCredentials(accessKeyId, accessKeySecret, securityToken);
        }
        return new BasicCredentials(accessKeyId, accessKeySecret);
    }
}

