/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.policy.retry.backoff;

import com.aliyuncs.policy.retry.RetryPolicyContext;
import com.aliyuncs.policy.retry.backoff.BackoffStrategy;
import java.util.Random;

public final class EqualJitterBackoffStrategy
extends BackoffStrategy {
    private static final int BASE_DELAY_CEILING = 86400000;
    private static final int MAX_BACKOFF_CEILING = 86400000;
    private final int baseDelay;
    private final int maxBackoffTime;
    private final Random random;

    public EqualJitterBackoffStrategy(Integer baseDelay, int maxBackoffTime, Random random) {
        this.baseDelay = Math.min(baseDelay, 86400000);
        this.maxBackoffTime = Math.min(maxBackoffTime, 86400000);
        this.random = random;
    }

    @Override
    public int computeDelayBeforeNextRetry(RetryPolicyContext context) {
        int ceil = this.calculateExponentialDelay(context.retriesAttempted(), this.baseDelay, this.maxBackoffTime);
        return ceil / 2 + this.random.nextInt(ceil / 2 + 1);
    }
}

