/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.dcdn.transform.v20180115;

import java.util.ArrayList;
import java.util.List;

import com.aliyuncs.dcdn.model.v20180115.DescribeDcdnDomainBpsDataByLayerResponse;
import com.aliyuncs.dcdn.model.v20180115.DescribeDcdnDomainBpsDataByLayerResponse.DataModule;
import com.aliyuncs.transform.UnmarshallerContext;


public class DescribeDcdnDomainBpsDataByLayerResponseUnmarshaller {

	public static DescribeDcdnDomainBpsDataByLayerResponse unmarshall(DescribeDcdnDomainBpsDataByLayerResponse describeDcdnDomainBpsDataByLayerResponse, UnmarshallerContext _ctx) {
		
		describeDcdnDomainBpsDataByLayerResponse.setRequestId(_ctx.stringValue("DescribeDcdnDomainBpsDataByLayerResponse.RequestId"));
		describeDcdnDomainBpsDataByLayerResponse.setDataInterval(_ctx.stringValue("DescribeDcdnDomainBpsDataByLayerResponse.DataInterval"));

		List<DataModule> bpsDataInterval = new ArrayList<DataModule>();
		for (int i = 0; i < _ctx.lengthValue("DescribeDcdnDomainBpsDataByLayerResponse.BpsDataInterval.Length"); i++) {
			DataModule dataModule = new DataModule();
			dataModule.setValue(_ctx.stringValue("DescribeDcdnDomainBpsDataByLayerResponse.BpsDataInterval["+ i +"].Value"));
			dataModule.setTrafficValue(_ctx.stringValue("DescribeDcdnDomainBpsDataByLayerResponse.BpsDataInterval["+ i +"].TrafficValue"));
			dataModule.setTimeStamp(_ctx.stringValue("DescribeDcdnDomainBpsDataByLayerResponse.BpsDataInterval["+ i +"].TimeStamp"));

			bpsDataInterval.add(dataModule);
		}
		describeDcdnDomainBpsDataByLayerResponse.setBpsDataInterval(bpsDataInterval);
	 
	 	return describeDcdnDomainBpsDataByLayerResponse;
	}
}