/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.dcdn.transform.v20180115;

import java.util.ArrayList;
import java.util.List;

import com.aliyuncs.dcdn.model.v20180115.DescribeDcdnRealTimeDeliveryFieldResponse;
import com.aliyuncs.dcdn.model.v20180115.DescribeDcdnRealTimeDeliveryFieldResponse.Fields;
import com.aliyuncs.transform.UnmarshallerContext;


public class DescribeDcdnRealTimeDeliveryFieldResponseUnmarshaller {

	public static DescribeDcdnRealTimeDeliveryFieldResponse unmarshall(DescribeDcdnRealTimeDeliveryFieldResponse describeDcdnRealTimeDeliveryFieldResponse, UnmarshallerContext _ctx) {
		
		describeDcdnRealTimeDeliveryFieldResponse.setRequestId(_ctx.stringValue("DescribeDcdnRealTimeDeliveryFieldResponse.RequestId"));

		List<Fields> content = new ArrayList<Fields>();
		for (int i = 0; i < _ctx.lengthValue("DescribeDcdnRealTimeDeliveryFieldResponse.Content.Length"); i++) {
			Fields fields = new Fields();
			fields.setDescription(_ctx.stringValue("DescribeDcdnRealTimeDeliveryFieldResponse.Content["+ i +"].Description"));
			fields.setFieldName(_ctx.stringValue("DescribeDcdnRealTimeDeliveryFieldResponse.Content["+ i +"].FieldName"));

			content.add(fields);
		}
		describeDcdnRealTimeDeliveryFieldResponse.setContent(content);
	 
	 	return describeDcdnRealTimeDeliveryFieldResponse;
	}
}