/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.dds.transform.v20151201;

import java.util.ArrayList;
import java.util.List;

import com.aliyuncs.dds.model.v20151201.DescribeAvailableTimeRangeResponse;
import com.aliyuncs.dds.model.v20151201.DescribeAvailableTimeRangeResponse.TimeRangeItem;
import com.aliyuncs.transform.UnmarshallerContext;


public class DescribeAvailableTimeRangeResponseUnmarshaller {

	public static DescribeAvailableTimeRangeResponse unmarshall(DescribeAvailableTimeRangeResponse describeAvailableTimeRangeResponse, UnmarshallerContext _ctx) {
		
		describeAvailableTimeRangeResponse.setRequestId(_ctx.stringValue("DescribeAvailableTimeRangeResponse.RequestId"));

		List<TimeRangeItem> timeRange = new ArrayList<TimeRangeItem>();
		for (int i = 0; i < _ctx.lengthValue("DescribeAvailableTimeRangeResponse.TimeRange.Length"); i++) {
			TimeRangeItem timeRangeItem = new TimeRangeItem();
			timeRangeItem.setStartTime(_ctx.stringValue("DescribeAvailableTimeRangeResponse.TimeRange["+ i +"].StartTime"));
			timeRangeItem.setEndTime(_ctx.stringValue("DescribeAvailableTimeRangeResponse.TimeRange["+ i +"].EndTime"));
			timeRangeItem.setStatus(_ctx.stringValue("DescribeAvailableTimeRangeResponse.TimeRange["+ i +"].Status"));
			timeRangeItem.setNodeId(_ctx.stringValue("DescribeAvailableTimeRangeResponse.TimeRange["+ i +"].NodeId"));
			timeRangeItem.setTaskId(_ctx.stringValue("DescribeAvailableTimeRangeResponse.TimeRange["+ i +"].TaskId"));

			timeRange.add(timeRangeItem);
		}
		describeAvailableTimeRangeResponse.setTimeRange(timeRange);
	 
	 	return describeAvailableTimeRangeResponse;
	}
}