/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.ecs.model.v20140526;

import java.util.List;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.ecs.transform.v20140526.DescribeReservedInstanceAutoRenewAttributeResponseUnmarshaller;
import com.aliyuncs.transform.UnmarshallerContext;

/**
 * @author auto create
 * @version 
 */
public class DescribeReservedInstanceAutoRenewAttributeResponse extends AcsResponse {

	private String requestId;

	private List<ReservedInstanceRenewAttribute> reservedInstanceRenewAttributes;

	public String getRequestId() {
		return this.requestId;
	}

	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public List<ReservedInstanceRenewAttribute> getReservedInstanceRenewAttributes() {
		return this.reservedInstanceRenewAttributes;
	}

	public void setReservedInstanceRenewAttributes(List<ReservedInstanceRenewAttribute> reservedInstanceRenewAttributes) {
		this.reservedInstanceRenewAttributes = reservedInstanceRenewAttributes;
	}

	public static class ReservedInstanceRenewAttribute {

		private String periodUnit;

		private Integer duration;

		private String reservedInstanceId;

		private String renewalStatus;

		public String getPeriodUnit() {
			return this.periodUnit;
		}

		public void setPeriodUnit(String periodUnit) {
			this.periodUnit = periodUnit;
		}

		public Integer getDuration() {
			return this.duration;
		}

		public void setDuration(Integer duration) {
			this.duration = duration;
		}

		public String getReservedInstanceId() {
			return this.reservedInstanceId;
		}

		public void setReservedInstanceId(String reservedInstanceId) {
			this.reservedInstanceId = reservedInstanceId;
		}

		public String getRenewalStatus() {
			return this.renewalStatus;
		}

		public void setRenewalStatus(String renewalStatus) {
			this.renewalStatus = renewalStatus;
		}
	}

	@Override
	public DescribeReservedInstanceAutoRenewAttributeResponse getInstance(UnmarshallerContext context) {
		return	DescribeReservedInstanceAutoRenewAttributeResponseUnmarshaller.unmarshall(this, context);
	}
}
