/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.ecs.model.v20140526;

import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.ecs.Endpoint;

/**
 * @author auto create
 * @version 
 */
public class DescribeSavingsPlanEstimationRequest extends RpcAcsRequest<DescribeSavingsPlanEstimationResponse> {
	   

	private String planType;

	private String estimationResource;

	private String resourceId;

	private String period;

	private String instanceTypeScope;

	private String periodUnit;

	private String offeringType;
	public DescribeSavingsPlanEstimationRequest() {
		super("Ecs", "2014-05-26", "DescribeSavingsPlanEstimation", "ecs");
		setProtocol(ProtocolType.HTTPS);
		setMethod(MethodType.POST);
		try {
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointMap").set(this, Endpoint.endpointMap);
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointRegional").set(this, Endpoint.endpointRegionalType);
		} catch (Exception e) {}
	}

	public String getPlanType() {
		return this.planType;
	}

	public void setPlanType(String planType) {
		this.planType = planType;
		if(planType != null){
			putQueryParameter("PlanType", planType);
		}
	}

	public String getEstimationResource() {
		return this.estimationResource;
	}

	public void setEstimationResource(String estimationResource) {
		this.estimationResource = estimationResource;
		if(estimationResource != null){
			putQueryParameter("EstimationResource", estimationResource);
		}
	}

	public String getResourceId() {
		return this.resourceId;
	}

	public void setResourceId(String resourceId) {
		this.resourceId = resourceId;
		if(resourceId != null){
			putQueryParameter("ResourceId", resourceId);
		}
	}

	public String getPeriod() {
		return this.period;
	}

	public void setPeriod(String period) {
		this.period = period;
		if(period != null){
			putQueryParameter("Period", period);
		}
	}

	public String getInstanceTypeScope() {
		return this.instanceTypeScope;
	}

	public void setInstanceTypeScope(String instanceTypeScope) {
		this.instanceTypeScope = instanceTypeScope;
		if(instanceTypeScope != null){
			putQueryParameter("InstanceTypeScope", instanceTypeScope);
		}
	}

	public String getPeriodUnit() {
		return this.periodUnit;
	}

	public void setPeriodUnit(String periodUnit) {
		this.periodUnit = periodUnit;
		if(periodUnit != null){
			putQueryParameter("PeriodUnit", periodUnit);
		}
	}

	public String getOfferingType() {
		return this.offeringType;
	}

	public void setOfferingType(String offeringType) {
		this.offeringType = offeringType;
		if(offeringType != null){
			putQueryParameter("OfferingType", offeringType);
		}
	}

	@Override
	public Class<DescribeSavingsPlanEstimationResponse> getResponseClass() {
		return DescribeSavingsPlanEstimationResponse.class;
	}

}
