/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.auth;

import com.google.common.base.Strings;
import com.google.common.net.UrlEscapers;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class AcsURLEncoder {
    public static final String URL_ENCODING = "UTF-8";

    public static String urlEncode(String path) throws URISyntaxException {
        if (Strings.isNullOrEmpty((String)path)) {
            return path;
        }
        return UrlEscapers.urlFragmentEscaper().escape(path);
    }

    public static String encode(String value) throws UnsupportedEncodingException {
        if (Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return URLEncoder.encode(value, URL_ENCODING);
    }

    public static String decode(String value) throws UnsupportedEncodingException {
        if (Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return URLDecoder.decode(value, URL_ENCODING);
    }

    public static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, URL_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }
}

