/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.auth;

import com.aliyuncs.fc.auth.AcsURLEncoder;
import com.aliyuncs.fc.auth.FcSignatureComposer;
import com.aliyuncs.fc.model.HttpMethod;
import com.aliyuncs.fc.utils.FcUtil;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class SignURLConfig {
    private HttpMethod method;
    private Date expires;
    private String serviceName;
    private String qualifier;
    private String functionName;
    private String customEndpoint;
    private String escapedPath;
    private Map<String, String> header;
    private Map<String, String[]> queries;

    public SignURLConfig(HttpMethod method, String serviceName, String functionName, Date expires) {
        this.method = method;
        this.serviceName = serviceName;
        this.functionName = functionName;
        this.expires = expires;
    }

    public String signURL(String apiVersion, String endpoint, String akID, String akSec, String stsToken) throws Exception {
        String orignalEscapedPath = this.escapedPath;
        if (Strings.isNullOrEmpty((String)orignalEscapedPath)) {
            orignalEscapedPath = "/";
        }
        String unescapedPath = AcsURLEncoder.decode(new URIBuilder(orignalEscapedPath).getPath());
        String serviceWithQualifier = this.serviceName;
        if (!Strings.isNullOrEmpty((String)this.qualifier)) {
            serviceWithQualifier = serviceWithQualifier + "." + this.qualifier;
        }
        String unescapedPathForSign = String.format("/%s/proxy/%s/%s%s", apiVersion, serviceWithQualifier, this.functionName, unescapedPath);
        String escapedPath = String.format("/%s/proxy/%s/%s%s", apiVersion, serviceWithQualifier, this.functionName, orignalEscapedPath);
        if (!Strings.isNullOrEmpty((String)this.customEndpoint)) {
            endpoint = this.customEndpoint;
            escapedPath = orignalEscapedPath;
            unescapedPathForSign = unescapedPath;
        }
        HashMap<String, String[]> queries = new HashMap<String, String[]>();
        if (this.queries != null) {
            for (Map.Entry<String, String[]> entry : this.queries.entrySet()) {
                String key = entry.getKey();
                String[] values = entry.getValue();
                if (values == null) continue;
                queries.put(key, (String[])values.clone());
            }
        }
        queries.put("x-fc-access-key-id", new String[]{akID});
        String expiresStr = String.format("%d", this.expires.getTime() / 1000L);
        queries.put("x-fc-expires", new String[]{expiresStr});
        if (!Strings.isNullOrEmpty((String)stsToken)) {
            queries.put("x-fc-security-token", new String[]{stsToken});
        }
        String fcResource = FcSignatureComposer.composeStringToSignWithMultiValue(this.method, unescapedPathForSign, this.header, queries);
        String signature = FcSignatureComposer.signString(fcResource, akSec);
        queries.put("x-fc-signature", new String[]{signature});
        return String.format("%s%s?%s", endpoint, escapedPath, FcUtil.concatMultiQueryString(queries));
    }

    public SignURLConfig setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    public SignURLConfig setCustomEndpoint(String customEndpoint) {
        this.customEndpoint = customEndpoint;
        return this;
    }

    public SignURLConfig setEscapedPath(String escapedPath) {
        this.escapedPath = escapedPath;
        return this;
    }

    public SignURLConfig setHeader(Map<String, String> header) {
        this.header = header;
        return this;
    }

    public SignURLConfig setQueries(Map<String, String[]> queries) {
        this.queries = queries;
        return this;
    }
}

