/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.client;

import com.aliyuncs.fc.client.AsyncClientInterface;
import com.aliyuncs.fc.client.AsyncInternalClient;
import com.aliyuncs.fc.client.FcCallback;
import com.aliyuncs.fc.config.Config;
import com.aliyuncs.fc.core.AsyncCompletion;
import com.aliyuncs.fc.core.FutureCallback;
import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.exceptions.ServerException;
import com.aliyuncs.fc.http.consumers.CreateFunctionResponseConsumer;
import com.aliyuncs.fc.http.consumers.CreateServiceResponseConsumer;
import com.aliyuncs.fc.http.consumers.DeleteFunctionResponseConsumer;
import com.aliyuncs.fc.http.consumers.DeleteServiceResponseConsumer;
import com.aliyuncs.fc.http.consumers.GetFunctionResponseConsumer;
import com.aliyuncs.fc.http.consumers.GetServiceResponseConsumer;
import com.aliyuncs.fc.http.consumers.InvokeFunctionResponseConsumer;
import com.aliyuncs.fc.http.consumers.ListFunctionsResponseConsumer;
import com.aliyuncs.fc.http.consumers.ListServicesResponseConsumer;
import com.aliyuncs.fc.http.consumers.UpdateFunctionResponseConsumer;
import com.aliyuncs.fc.http.consumers.UpdateServiceResponseConsumer;
import com.aliyuncs.fc.model.HttpMethod;
import com.aliyuncs.fc.request.CreateFunctionRequest;
import com.aliyuncs.fc.request.CreateServiceRequest;
import com.aliyuncs.fc.request.DeleteFunctionRequest;
import com.aliyuncs.fc.request.DeleteServiceRequest;
import com.aliyuncs.fc.request.GetFunctionRequest;
import com.aliyuncs.fc.request.GetServiceRequest;
import com.aliyuncs.fc.request.HttpInvokeFunctionRequest;
import com.aliyuncs.fc.request.InvokeFunctionRequest;
import com.aliyuncs.fc.request.ListFunctionsRequest;
import com.aliyuncs.fc.request.ListServicesRequest;
import com.aliyuncs.fc.request.UpdateFunctionRequest;
import com.aliyuncs.fc.request.UpdateServiceRequest;
import com.aliyuncs.fc.response.CreateFunctionResponse;
import com.aliyuncs.fc.response.CreateServiceResponse;
import com.aliyuncs.fc.response.DeleteFunctionResponse;
import com.aliyuncs.fc.response.DeleteServiceResponse;
import com.aliyuncs.fc.response.GetFunctionResponse;
import com.aliyuncs.fc.response.GetServiceResponse;
import com.aliyuncs.fc.response.InvokeFunctionResponse;
import com.aliyuncs.fc.response.ListFunctionsResponse;
import com.aliyuncs.fc.response.ListServicesResponse;
import com.aliyuncs.fc.response.UpdateFunctionResponse;
import com.aliyuncs.fc.response.UpdateServiceResponse;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AsyncClient
implements AsyncClientInterface {
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_APPLICATION_STREAM = "application/octet-stream";
    private Config config;
    private AsyncInternalClient internalClient;
    private ExecutorService executor;

    public AsyncClient(Config config) {
        this.config = config;
        this.internalClient = new AsyncInternalClient(config);
        this.executor = Executors.newFixedThreadPool(config.getThreadCount());
    }

    @Override
    public Future<CreateFunctionResponse> createFunction(CreateFunctionRequest request, FcCallback<CreateFunctionRequest, CreateFunctionResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new CreateFunctionResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST, false);
        return f;
    }

    @Override
    public Future<InvokeFunctionResponse> invokeFunction(InvokeFunctionRequest request, FcCallback<InvokeFunctionRequest, InvokeFunctionResponse> callback) throws ClientException, ServerException {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        if (request instanceof HttpInvokeFunctionRequest) {
            String contentType = CONTENT_TYPE_APPLICATION_STREAM;
            if (request.getHeaders() != null && request.getHeaders().containsKey("Content-Type")) {
                contentType = request.getHeaders().get("Content-Type");
            }
            this.internalClient.asyncSend(request, new InvokeFunctionResponseConsumer(), completion, contentType, ((HttpInvokeFunctionRequest)request).getMethod(), true);
        } else {
            this.internalClient.asyncSend(request, new InvokeFunctionResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_STREAM, HttpMethod.POST, false);
        }
        return f;
    }

    @Override
    public Future<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest request, FcCallback<UpdateFunctionRequest, UpdateFunctionResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new UpdateFunctionResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT, false);
        return f;
    }

    @Override
    public Future<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest request, FcCallback<DeleteFunctionRequest, DeleteFunctionResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new DeleteFunctionResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE, false);
        return f;
    }

    @Override
    public Future<ListFunctionsResponse> listFunctions(ListFunctionsRequest request, FcCallback<ListFunctionsRequest, ListFunctionsResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new ListFunctionsResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET, false);
        return f;
    }

    @Override
    public Future<GetFunctionResponse> getFunction(GetFunctionRequest request, FcCallback<GetFunctionRequest, GetFunctionResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new GetFunctionResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET, false);
        return f;
    }

    @Override
    public Future<CreateServiceResponse> createService(CreateServiceRequest request, FcCallback<CreateServiceRequest, CreateServiceResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new CreateServiceResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST, false);
        return f;
    }

    @Override
    public Future<UpdateServiceResponse> updateService(UpdateServiceRequest request, FcCallback<UpdateServiceRequest, UpdateServiceResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new UpdateServiceResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT, false);
        return f;
    }

    @Override
    public Future<DeleteServiceResponse> deleteService(DeleteServiceRequest request, FcCallback<DeleteServiceRequest, DeleteServiceResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new DeleteServiceResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE, false);
        return f;
    }

    @Override
    public Future<ListServicesResponse> listServices(ListServicesRequest request, FcCallback<ListServicesRequest, ListServicesResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new ListServicesResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET, false);
        return f;
    }

    @Override
    public Future<GetServiceResponse> getService(GetServiceRequest request, FcCallback<GetServiceRequest, GetServiceResponse> callback) {
        AsyncCompletion completion = new AsyncCompletion(request, this.executor);
        FutureCallback f = new FutureCallback();
        completion.addCallback((FcCallback)f);
        if (callback != null) {
            f.addCallback((FcCallback)callback);
        }
        this.internalClient.asyncSend(request, new GetServiceResponseConsumer(), completion, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET, false);
        return f;
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdownNow();
        this.internalClient.close();
    }
}

