/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.client;

import com.aliyuncs.fc.config.Config;
import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.consumers.AbstractResponseConsumer;
import com.aliyuncs.fc.model.HttpAuthType;
import com.aliyuncs.fc.model.HttpMethod;
import com.aliyuncs.fc.model.PrepareUrl;
import com.aliyuncs.fc.request.HttpInvokeFunctionRequest;
import com.aliyuncs.fc.utils.FcUtil;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;

public class AsyncInternalClient {
    private Config config;
    private CloseableHttpAsyncClient httpClient;

    public AsyncInternalClient(Config config) {
        this.config = config;
        try {
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            cm.setMaxTotal(config.getMaxConnectCount());
            cm.setDefaultMaxPerRoute(config.getMaxPerRoute());
            this.httpClient = this.createHttpAsyncClient(config, cm);
            this.httpClient.start();
        }
        catch (IOReactorException e) {
            throw new ClientException(e);
        }
    }

    private CloseableHttpAsyncClient createHttpAsyncClient(Config config, PoolingNHttpClientConnectionManager cm) {
        HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClients.custom();
        httpClientBuilder.setConnectionManager((NHttpClientConnectionManager)cm);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.getConnectTimeoutMillis()).setConnectionRequestTimeout(config.getConnectionRequestTimeoutMillis()).setSocketTimeout(config.getReadTimeoutMillis()).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setUserAgent(config.getUserAgent());
        httpClientBuilder.disableCookieManagement();
        return httpClientBuilder.build();
    }

    protected <Res> void asyncSend(com.aliyuncs.fc.http.HttpRequest request, AbstractResponseConsumer<Res> consumer, FutureCallback<Res> callback, String contentType, HttpMethod method, boolean httpInvoke) throws ClientException {
        try {
            this.config.refreshCredentials();
            if (!httpInvoke || !HttpAuthType.ANONYMOUS.equals((Object)((HttpInvokeFunctionRequest)request).getAuthType())) {
                FcUtil.signRequest(this.config, request, contentType, method, httpInvoke);
            }
            PrepareUrl prepareUrl = FcUtil.prepareUrl(request.getPath(), request.getQueryParams(), this.config);
            RequestBuilder requestBuilder = RequestBuilder.create((String)method.name()).setUri(prepareUrl.getUrl());
            this.copyToRequest(request, requestBuilder);
            HttpUriRequest httpRequest = requestBuilder.build();
            HttpHost httpHost = URIUtils.extractHost((URI)httpRequest.getURI());
            this.httpClient.execute((HttpAsyncRequestProducer)new FcRequestProducer(httpHost, (HttpRequest)httpRequest), consumer, callback);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    private void copyToRequest(com.aliyuncs.fc.http.HttpRequest request, RequestBuilder requestBuilder) {
        if (request.getPayload() != null) {
            requestBuilder.setEntity((HttpEntity)new ByteArrayEntity(request.getPayload()));
        }
        Map<String, String> headers = request.getHeaders();
        for (Map.Entry<String, String> item : headers.entrySet()) {
            requestBuilder.setHeader(item.getKey(), item.getValue());
        }
    }

    public void close() throws IOException {
        this.httpClient.close();
    }

    static class FcRequestProducer
    extends BasicAsyncRequestProducer {
        public FcRequestProducer(HttpHost target, HttpRequest request) {
            super(target, request);
        }

        public void requestCompleted(HttpContext context) {
            super.requestCompleted(context);
        }
    }
}

