/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.client;

import com.aliyuncs.fc.config.Config;
import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.exceptions.ServerException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.http.HttpResponse;
import com.aliyuncs.fc.model.HttpAuthType;
import com.aliyuncs.fc.model.HttpMethod;
import com.aliyuncs.fc.model.PrepareUrl;
import com.aliyuncs.fc.request.HttpInvokeFunctionRequest;
import com.aliyuncs.fc.utils.FcUtil;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class DefaultFcClient {
    public static final Boolean AUTO_RETRY = true;
    public static final int MAX_RETRIES = 3;
    private final Config config;

    public DefaultFcClient(Config config) {
        this.config = config;
    }

    public HttpResponse doAction(HttpRequest request, String form, HttpMethod method) throws ClientException, ServerException {
        request.validate();
        this.config.refreshCredentials();
        try {
            int retryTimes = 0;
            HttpResponse response = null;
            boolean httpInvoke = false;
            if (request instanceof HttpInvokeFunctionRequest) {
                httpInvoke = true;
            }
            do {
                if (!httpInvoke || !HttpAuthType.ANONYMOUS.equals((Object)((HttpInvokeFunctionRequest)request).getAuthType())) {
                    FcUtil.signRequest(this.config, request, form, method, httpInvoke);
                }
                PrepareUrl prepareUrl = FcUtil.prepareUrl(request.getPath(), request.getQueryParams(), this.config);
                response = HttpResponse.getResponse(prepareUrl.getUrl(), request, method, this.config.getConnectTimeoutMillis(), this.config.getReadTimeoutMillis());
                ++retryTimes;
                if (!httpInvoke) continue;
                return response;
            } while (500 <= response.getStatus() && AUTO_RETRY.booleanValue() && retryTimes < 3);
            if (response.getStatus() >= 500) {
                ServerException se;
                String requestId = response.getHeader("X-Fc-Request-Id");
                String stringContent = response.getContent() == null ? "" : FcUtil.toDefaultCharset(response.getContent());
                try {
                    se = (ServerException)new Gson().fromJson(stringContent, ServerException.class);
                }
                catch (JsonParseException e) {
                    se = new ServerException("InternalServiceError", "Failed to parse response content", requestId);
                }
                se.setStatusCode(response.getStatus());
                se.setRequestId(requestId);
                throw se;
            }
            if (response.getStatus() >= 300) {
                ClientException ce;
                if (response.getContent() == null) {
                    ce = new ClientException("SDK.ServerUnreachable", "Failed to get response content from server");
                } else {
                    try {
                        ce = (ClientException)new Gson().fromJson(FcUtil.toDefaultCharset(response.getContent()), ClientException.class);
                    }
                    catch (JsonParseException e) {
                        ce = new ClientException("SDK.ResponseNotParsable", "Failed to parse response content", e);
                    }
                }
                if (ce == null) {
                    ce = new ClientException("SDK.UnknownError", "Unknown client error");
                }
                ce.setStatusCode(response.getStatus());
                ce.setRequestId(response.getHeader("X-Fc-Request-Id"));
                throw ce;
            }
            return response;
        }
        catch (InvalidKeyException exp) {
            throw new ClientException("SDK.InvalidAccessSecret", "Speicified access secret is not valid.");
        }
        catch (SocketTimeoutException exp) {
            throw new ClientException("SDK.ServerUnreachable", "SocketTimeoutException has occurred on a socket read or accept.");
        }
        catch (IOException exp) {
            throw new ClientException("SDK.ServerUnreachable", "Server unreachable: " + exp.toString());
        }
        catch (NoSuchAlgorithmException exp) {
            throw new ClientException("SDK.InvalidMD5Algorithm", "MD5 hash is not supported by client side.");
        }
        catch (URISyntaxException e) {
            throw new ClientException("SDK.InvalidURL", "url is not valid: " + e.getMessage());
        }
    }
}

