/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.client;

import com.aliyuncs.fc.auth.SignURLConfig;
import com.aliyuncs.fc.client.DefaultFcClient;
import com.aliyuncs.fc.config.Config;
import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.exceptions.ServerException;
import com.aliyuncs.fc.http.HttpResponse;
import com.aliyuncs.fc.model.AccountSettings;
import com.aliyuncs.fc.model.AliasMetaData;
import com.aliyuncs.fc.model.AsyncConfig;
import com.aliyuncs.fc.model.CustomDomainMetaData;
import com.aliyuncs.fc.model.FunctionCodeMetadata;
import com.aliyuncs.fc.model.HttpMethod;
import com.aliyuncs.fc.model.OnDemandConfigMetadata;
import com.aliyuncs.fc.model.ProvisionConfig;
import com.aliyuncs.fc.model.ProvisionTarget;
import com.aliyuncs.fc.model.TagBaseResponse;
import com.aliyuncs.fc.model.TagMetaData;
import com.aliyuncs.fc.model.TriggerMetadata;
import com.aliyuncs.fc.model.VersionMetaData;
import com.aliyuncs.fc.request.CreateAliasRequest;
import com.aliyuncs.fc.request.CreateCustomDomainRequest;
import com.aliyuncs.fc.request.CreateFunctionRequest;
import com.aliyuncs.fc.request.CreateServiceRequest;
import com.aliyuncs.fc.request.CreateTriggerRequest;
import com.aliyuncs.fc.request.CreateVpcBindingRequest;
import com.aliyuncs.fc.request.DeleteAliasRequest;
import com.aliyuncs.fc.request.DeleteCustomDomainRequest;
import com.aliyuncs.fc.request.DeleteFunctionAsyncConfigRequest;
import com.aliyuncs.fc.request.DeleteFunctionRequest;
import com.aliyuncs.fc.request.DeleteOnDemandConfigRequest;
import com.aliyuncs.fc.request.DeleteServiceRequest;
import com.aliyuncs.fc.request.DeleteTriggerRequest;
import com.aliyuncs.fc.request.DeleteVersionRequest;
import com.aliyuncs.fc.request.DeleteVpcBindingRequest;
import com.aliyuncs.fc.request.GetAccountSettingsRequest;
import com.aliyuncs.fc.request.GetAliasRequest;
import com.aliyuncs.fc.request.GetCustomDomainRequest;
import com.aliyuncs.fc.request.GetFunctionAsyncConfigRequest;
import com.aliyuncs.fc.request.GetFunctionCodeRequest;
import com.aliyuncs.fc.request.GetFunctionRequest;
import com.aliyuncs.fc.request.GetOnDemandConfigRequest;
import com.aliyuncs.fc.request.GetProvisionConfigRequest;
import com.aliyuncs.fc.request.GetResourceTagsRequest;
import com.aliyuncs.fc.request.GetServiceRequest;
import com.aliyuncs.fc.request.GetTriggerRequest;
import com.aliyuncs.fc.request.HttpInvokeFunctionRequest;
import com.aliyuncs.fc.request.InvokeFunctionRequest;
import com.aliyuncs.fc.request.ListAliasesRequest;
import com.aliyuncs.fc.request.ListCustomDomainsRequest;
import com.aliyuncs.fc.request.ListFunctionAsyncConfigsRequest;
import com.aliyuncs.fc.request.ListFunctionsRequest;
import com.aliyuncs.fc.request.ListOnDemandConfigsRequest;
import com.aliyuncs.fc.request.ListProvisionConfigsRequest;
import com.aliyuncs.fc.request.ListReservedCapacitiesRequest;
import com.aliyuncs.fc.request.ListServicesRequest;
import com.aliyuncs.fc.request.ListTriggersRequest;
import com.aliyuncs.fc.request.ListVersionsRequest;
import com.aliyuncs.fc.request.ListVpcBindingsRequest;
import com.aliyuncs.fc.request.PublishVersionRequest;
import com.aliyuncs.fc.request.PutFunctionAsyncConfigRequest;
import com.aliyuncs.fc.request.PutOnDemandConfigRequest;
import com.aliyuncs.fc.request.PutProvisionConfigRequest;
import com.aliyuncs.fc.request.TagResourceRequest;
import com.aliyuncs.fc.request.UntagResourceRequest;
import com.aliyuncs.fc.request.UpdateAliasRequest;
import com.aliyuncs.fc.request.UpdateCustomDomainRequest;
import com.aliyuncs.fc.request.UpdateFunctionRequest;
import com.aliyuncs.fc.request.UpdateServiceRequest;
import com.aliyuncs.fc.request.UpdateTriggerRequest;
import com.aliyuncs.fc.response.CreateAliasResponse;
import com.aliyuncs.fc.response.CreateCustomDomainResponse;
import com.aliyuncs.fc.response.CreateFunctionResponse;
import com.aliyuncs.fc.response.CreateServiceResponse;
import com.aliyuncs.fc.response.CreateTriggerResponse;
import com.aliyuncs.fc.response.CreateVpcBindingResponse;
import com.aliyuncs.fc.response.DeleteAliasResponse;
import com.aliyuncs.fc.response.DeleteCustomDomainResponse;
import com.aliyuncs.fc.response.DeleteFunctionAsyncConfigResponse;
import com.aliyuncs.fc.response.DeleteFunctionResponse;
import com.aliyuncs.fc.response.DeleteOnDemandConfigResponse;
import com.aliyuncs.fc.response.DeleteServiceResponse;
import com.aliyuncs.fc.response.DeleteTriggerResponse;
import com.aliyuncs.fc.response.DeleteVersionResponse;
import com.aliyuncs.fc.response.DeleteVpcBindingResponse;
import com.aliyuncs.fc.response.GetAccountSettingsResponse;
import com.aliyuncs.fc.response.GetAliasResponse;
import com.aliyuncs.fc.response.GetCustomDomainResponse;
import com.aliyuncs.fc.response.GetFunctionAsyncConfigResponse;
import com.aliyuncs.fc.response.GetFunctionCodeResponse;
import com.aliyuncs.fc.response.GetFunctionResponse;
import com.aliyuncs.fc.response.GetOnDemandConfigResponse;
import com.aliyuncs.fc.response.GetProvisionConfigResponse;
import com.aliyuncs.fc.response.GetResourceTagsResponse;
import com.aliyuncs.fc.response.GetServiceResponse;
import com.aliyuncs.fc.response.GetTriggerResponse;
import com.aliyuncs.fc.response.InvokeFunctionResponse;
import com.aliyuncs.fc.response.ListAliasesResponse;
import com.aliyuncs.fc.response.ListCustomDomainsResponse;
import com.aliyuncs.fc.response.ListFunctionAsyncConfigsResponse;
import com.aliyuncs.fc.response.ListFunctionsResponse;
import com.aliyuncs.fc.response.ListOnDemandConfigsResponse;
import com.aliyuncs.fc.response.ListProvisionConfigsResponse;
import com.aliyuncs.fc.response.ListReservedCapacitiesResponse;
import com.aliyuncs.fc.response.ListServicesResponse;
import com.aliyuncs.fc.response.ListTriggersResponse;
import com.aliyuncs.fc.response.ListVersionsResponse;
import com.aliyuncs.fc.response.ListVpcBindingsResponse;
import com.aliyuncs.fc.response.PublishVersionResponse;
import com.aliyuncs.fc.response.PutFunctionAsyncConfigResponse;
import com.aliyuncs.fc.response.PutOnDemandConfigResponse;
import com.aliyuncs.fc.response.PutProvisionConfigResponse;
import com.aliyuncs.fc.response.ResponseFactory;
import com.aliyuncs.fc.response.TagResourceResponse;
import com.aliyuncs.fc.response.UntagResourceResponse;
import com.aliyuncs.fc.response.UpdateAliasResponse;
import com.aliyuncs.fc.response.UpdateCustomDomainResponse;
import com.aliyuncs.fc.response.UpdateFunctionResponse;
import com.aliyuncs.fc.response.UpdateServiceResponse;
import com.aliyuncs.fc.response.UpdateTriggerResponse;
import com.aliyuncs.fc.utils.FcUtil;
import com.google.gson.Gson;
import java.util.logging.Logger;

public class FunctionComputeClient {
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_APPLICATION_STREAM = "application/octet-stream";
    private static final Logger LOGGER = Logger.getLogger("debug");
    private static final Gson GSON = new Gson();
    private final DefaultFcClient client;
    private final Config config;

    public FunctionComputeClient(String region, String uid, String accessKeyId, String accessKeySecret) {
        this.config = new Config(region, uid, accessKeyId, accessKeySecret, null, false);
        this.client = new DefaultFcClient(this.config);
    }

    public FunctionComputeClient(Config config) {
        this.config = config;
        this.client = new DefaultFcClient(config);
    }

    public Config getConfig() {
        return this.config;
    }

    public void setEndpoint(String endpoint) {
        this.config.setEndpoint(endpoint);
    }

    public GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        GetAccountSettingsResponse getAccountSettingsOutput = new GetAccountSettingsResponse();
        AccountSettings accountSettings = (AccountSettings)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), AccountSettings.class);
        getAccountSettingsOutput.setHeaders(response.getHeaders());
        getAccountSettingsOutput.setStatus(response.getStatus());
        getAccountSettingsOutput.setAccountSettings(accountSettings);
        return getAccountSettingsOutput;
    }

    public DeleteServiceResponse deleteService(DeleteServiceRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        return ResponseFactory.genDeleteServiceResponse(response);
    }

    public DeleteVpcBindingResponse deleteVpcBinding(DeleteVpcBindingRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        return ResponseFactory.genDeleteVpcBindingResponse(response);
    }

    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        return ResponseFactory.genDeleteFunctionResponse(response);
    }

    public DeleteCustomDomainResponse deleteCustomDomain(DeleteCustomDomainRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        DeleteCustomDomainResponse deleteCustomDomainResponse = new DeleteCustomDomainResponse();
        deleteCustomDomainResponse.setHeaders(response.getHeaders());
        deleteCustomDomainResponse.setStatus(response.getStatus());
        return deleteCustomDomainResponse;
    }

    public GetServiceResponse getService(GetServiceRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        return ResponseFactory.genGetServiceResponse(response);
    }

    public GetFunctionResponse getFunction(GetFunctionRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        return ResponseFactory.genGetFunctionResponse(response);
    }

    public GetFunctionCodeResponse getFunctionCode(GetFunctionCodeRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        FunctionCodeMetadata functionCodeMetadata = (FunctionCodeMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), FunctionCodeMetadata.class);
        GetFunctionCodeResponse getFunctionCodeResponse = new GetFunctionCodeResponse();
        getFunctionCodeResponse.setFunctionCodeMetadata(functionCodeMetadata);
        getFunctionCodeResponse.setHeaders(response.getHeaders());
        getFunctionCodeResponse.setContent(response.getContent());
        getFunctionCodeResponse.setStatus(response.getStatus());
        return getFunctionCodeResponse;
    }

    public GetCustomDomainResponse getCustomDomain(GetCustomDomainRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        CustomDomainMetaData customDomainMetadata = (CustomDomainMetaData)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), CustomDomainMetaData.class);
        GetCustomDomainResponse getCustomDomainResponse = new GetCustomDomainResponse();
        getCustomDomainResponse.setCustomDomainMetadata(customDomainMetadata);
        getCustomDomainResponse.setHeaders(response.getHeaders());
        getCustomDomainResponse.setContent(response.getContent());
        getCustomDomainResponse.setStatus(response.getStatus());
        return getCustomDomainResponse;
    }

    public CreateServiceResponse createService(CreateServiceRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST);
        return ResponseFactory.genCreateServiceResponse(response);
    }

    public CreateVpcBindingResponse createVpcBinding(CreateVpcBindingRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST);
        return ResponseFactory.genCreateVpcBindingResponse(response);
    }

    public CreateFunctionResponse createFunction(CreateFunctionRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST);
        return ResponseFactory.genCreateFunctionResponse(response);
    }

    public UpdateFunctionResponse updateFunction(UpdateFunctionRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT);
        return ResponseFactory.genUpdateFunctionResponse(response);
    }

    public UpdateServiceResponse updateService(UpdateServiceRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT);
        return ResponseFactory.genUpdateServiceResponse(response);
    }

    public CreateCustomDomainResponse createCustomDomain(CreateCustomDomainRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST);
        CustomDomainMetaData customDomainMetaData = (CustomDomainMetaData)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), CustomDomainMetaData.class);
        CreateCustomDomainResponse createCustomDomainResponse = new CreateCustomDomainResponse();
        createCustomDomainResponse.setCustomDomainMetadata(customDomainMetaData);
        createCustomDomainResponse.setHeaders(response.getHeaders());
        createCustomDomainResponse.setContent(response.getContent());
        createCustomDomainResponse.setStatus(response.getStatus());
        return createCustomDomainResponse;
    }

    public UpdateCustomDomainResponse updateCustomDomain(UpdateCustomDomainRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT);
        CustomDomainMetaData customDomainMetadata = (CustomDomainMetaData)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), CustomDomainMetaData.class);
        UpdateCustomDomainResponse updateCustomDomainResponse = new UpdateCustomDomainResponse();
        updateCustomDomainResponse.setCustomDomainMetadata(customDomainMetadata);
        updateCustomDomainResponse.setHeaders(response.getHeaders());
        updateCustomDomainResponse.setContent(response.getContent());
        updateCustomDomainResponse.setStatus(response.getStatus());
        return updateCustomDomainResponse;
    }

    public ListServicesResponse listServices(ListServicesRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        return ResponseFactory.genListServiceResponse(response);
    }

    public ListFunctionsResponse listFunctions(ListFunctionsRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        return ResponseFactory.genListFunctionResponse(response);
    }

    public ListCustomDomainsResponse listCustomDomains(ListCustomDomainsRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        ListCustomDomainsResponse listCustomDomainsResponse = (ListCustomDomainsResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListCustomDomainsResponse.class);
        listCustomDomainsResponse.setHeaders(response.getHeaders());
        listCustomDomainsResponse.setContent(response.getContent());
        listCustomDomainsResponse.setStatus(response.getStatus());
        return listCustomDomainsResponse;
    }

    public ListReservedCapacitiesResponse listReservedCapacities(ListReservedCapacitiesRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        ListReservedCapacitiesResponse listReservedCapacitiesResponse = (ListReservedCapacitiesResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListReservedCapacitiesResponse.class);
        listReservedCapacitiesResponse.setHeaders(response.getHeaders());
        listReservedCapacitiesResponse.setContent(response.getContent());
        listReservedCapacitiesResponse.setStatus(response.getStatus());
        return listReservedCapacitiesResponse;
    }

    public CreateTriggerResponse createTrigger(CreateTriggerRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST);
        TriggerMetadata triggerMetadata = (TriggerMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), TriggerMetadata.class);
        CreateTriggerResponse createTriggerResponse = new CreateTriggerResponse();
        createTriggerResponse.setTriggerMetadata(triggerMetadata);
        createTriggerResponse.setHeaders(response.getHeaders());
        createTriggerResponse.setContent(response.getContent());
        createTriggerResponse.setStatus(response.getStatus());
        return createTriggerResponse;
    }

    public DeleteTriggerResponse deleteTrigger(DeleteTriggerRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        DeleteTriggerResponse deleteTriggerResponse = new DeleteTriggerResponse();
        deleteTriggerResponse.setHeaders(response.getHeaders());
        deleteTriggerResponse.setStatus(response.getStatus());
        return deleteTriggerResponse;
    }

    public UpdateTriggerResponse updateTrigger(UpdateTriggerRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT);
        TriggerMetadata triggerMetadata = (TriggerMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), TriggerMetadata.class);
        UpdateTriggerResponse updateTriggerResponse = new UpdateTriggerResponse();
        updateTriggerResponse.setTriggerMetadata(triggerMetadata);
        updateTriggerResponse.setHeaders(response.getHeaders());
        updateTriggerResponse.setContent(response.getContent());
        updateTriggerResponse.setStatus(response.getStatus());
        return updateTriggerResponse;
    }

    public GetTriggerResponse getTrigger(GetTriggerRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        TriggerMetadata triggerMetadata = (TriggerMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), TriggerMetadata.class);
        GetTriggerResponse getTriggerResponse = new GetTriggerResponse();
        getTriggerResponse.setTriggerMetadata(triggerMetadata);
        getTriggerResponse.setHeaders(response.getHeaders());
        getTriggerResponse.setContent(response.getContent());
        getTriggerResponse.setStatus(response.getStatus());
        return getTriggerResponse;
    }

    public ListTriggersResponse listTriggers(ListTriggersRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        ListTriggersResponse listTriggersResponse = (ListTriggersResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListTriggersResponse.class);
        listTriggersResponse.setHeaders(response.getHeaders());
        listTriggersResponse.setContent(response.getContent());
        listTriggersResponse.setStatus(response.getStatus());
        return listTriggersResponse;
    }

    public ListVpcBindingsResponse listVpcBindings(ListVpcBindingsRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        System.out.println(FcUtil.toDefaultCharset(response.getContent()));
        ListVpcBindingsResponse listVpcBindingsResponse = (ListVpcBindingsResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListVpcBindingsResponse.class);
        listVpcBindingsResponse.setHeaders(response.getHeaders());
        listVpcBindingsResponse.setStatus(response.getStatus());
        listVpcBindingsResponse.setContent(response.getContent());
        return ResponseFactory.genListVpcBindingsResponse(response);
    }

    public CreateAliasResponse createAlias(CreateAliasRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST);
        AliasMetaData aliasMetaData = (AliasMetaData)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), AliasMetaData.class);
        CreateAliasResponse createAliasResponse = new CreateAliasResponse(aliasMetaData);
        createAliasResponse.setHeaders(response.getHeaders());
        createAliasResponse.setContent(response.getContent());
        createAliasResponse.setStatus(response.getStatus());
        return createAliasResponse;
    }

    public DeleteAliasResponse deleteAlias(DeleteAliasRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        DeleteAliasResponse deleteAliasResponse = new DeleteAliasResponse();
        deleteAliasResponse.setHeaders(response.getHeaders());
        deleteAliasResponse.setStatus(response.getStatus());
        return deleteAliasResponse;
    }

    public UpdateAliasResponse updateAlias(UpdateAliasRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT);
        AliasMetaData aliasMetadata = (AliasMetaData)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), AliasMetaData.class);
        UpdateAliasResponse updateAliasResponse = new UpdateAliasResponse(aliasMetadata);
        updateAliasResponse.setHeaders(response.getHeaders());
        updateAliasResponse.setContent(response.getContent());
        updateAliasResponse.setStatus(response.getStatus());
        return updateAliasResponse;
    }

    public GetAliasResponse getAlias(GetAliasRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        AliasMetaData aliasMetadata = (AliasMetaData)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), AliasMetaData.class);
        GetAliasResponse getAliasResponse = new GetAliasResponse(aliasMetadata);
        getAliasResponse.setHeaders(response.getHeaders());
        getAliasResponse.setContent(response.getContent());
        getAliasResponse.setStatus(response.getStatus());
        return getAliasResponse;
    }

    public ListAliasesResponse listAliases(ListAliasesRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        ListAliasesResponse listAliasesResponse = (ListAliasesResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListAliasesResponse.class);
        listAliasesResponse.setHeaders(response.getHeaders());
        listAliasesResponse.setContent(response.getContent());
        listAliasesResponse.setStatus(response.getStatus());
        return listAliasesResponse;
    }

    public PublishVersionResponse publishVersion(PublishVersionRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST);
        VersionMetaData versionMetaData = (VersionMetaData)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), VersionMetaData.class);
        PublishVersionResponse publishVersionResponse = new PublishVersionResponse(versionMetaData);
        publishVersionResponse.setHeaders(response.getHeaders());
        publishVersionResponse.setContent(response.getContent());
        publishVersionResponse.setStatus(response.getStatus());
        return publishVersionResponse;
    }

    public DeleteVersionResponse deleteVersion(DeleteVersionRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        DeleteVersionResponse deleteVersionResponse = new DeleteVersionResponse();
        deleteVersionResponse.setHeaders(response.getHeaders());
        deleteVersionResponse.setStatus(response.getStatus());
        return deleteVersionResponse;
    }

    public ListVersionsResponse listVersions(ListVersionsRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        ListVersionsResponse listVersionsResponse = (ListVersionsResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListVersionsResponse.class);
        listVersionsResponse.setHeaders(response.getHeaders());
        listVersionsResponse.setContent(response.getContent());
        listVersionsResponse.setStatus(response.getStatus());
        return listVersionsResponse;
    }

    public PutProvisionConfigResponse putProvisionConfig(PutProvisionConfigRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT);
        ProvisionTarget provisionTarget = (ProvisionTarget)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ProvisionTarget.class);
        PutProvisionConfigResponse putProvisionConfigResponse = new PutProvisionConfigResponse(provisionTarget);
        putProvisionConfigResponse.setHeaders(response.getHeaders());
        putProvisionConfigResponse.setContent(response.getContent());
        putProvisionConfigResponse.setStatus(response.getStatus());
        return putProvisionConfigResponse;
    }

    public GetProvisionConfigResponse getProvisionConfig(GetProvisionConfigRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        ProvisionConfig provisionConfig = (ProvisionConfig)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ProvisionConfig.class);
        GetProvisionConfigResponse getProvisionConfigResponse = new GetProvisionConfigResponse(provisionConfig);
        getProvisionConfigResponse.setHeaders(response.getHeaders());
        getProvisionConfigResponse.setContent(response.getContent());
        getProvisionConfigResponse.setStatus(response.getStatus());
        return getProvisionConfigResponse;
    }

    public ListProvisionConfigsResponse listProvisionConfigs(ListProvisionConfigsRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        ListProvisionConfigsResponse listProvisionConfigsResponse = (ListProvisionConfigsResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListProvisionConfigsResponse.class);
        listProvisionConfigsResponse.setHeaders(response.getHeaders());
        listProvisionConfigsResponse.setContent(response.getContent());
        listProvisionConfigsResponse.setStatus(response.getStatus());
        return listProvisionConfigsResponse;
    }

    public TagResourceResponse tagResource(TagResourceRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.POST);
        TagBaseResponse baseResp = (TagBaseResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), TagBaseResponse.class);
        TagResourceResponse tagResourceResponse = new TagResourceResponse();
        tagResourceResponse.setHeaders(response.getHeaders());
        tagResourceResponse.setContent(response.getContent());
        tagResourceResponse.setStatus(response.getStatus());
        return tagResourceResponse;
    }

    public UntagResourceResponse untagResource(UntagResourceRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        TagBaseResponse baseResp = (TagBaseResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), TagBaseResponse.class);
        UntagResourceResponse untagResourceResponse = new UntagResourceResponse();
        untagResourceResponse.setHeaders(response.getHeaders());
        untagResourceResponse.setContent(response.getContent());
        untagResourceResponse.setStatus(response.getStatus());
        return untagResourceResponse;
    }

    public GetResourceTagsResponse getResourceTags(GetResourceTagsRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        TagMetaData tagMetaData = (TagMetaData)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), TagMetaData.class);
        GetResourceTagsResponse getResourceTagsResponse = new GetResourceTagsResponse();
        getResourceTagsResponse.setTagMetadata(tagMetaData);
        getResourceTagsResponse.setHeaders(response.getHeaders());
        getResourceTagsResponse.setContent(response.getContent());
        getResourceTagsResponse.setStatus(response.getStatus());
        return getResourceTagsResponse;
    }

    public InvokeFunctionResponse invokeFunction(InvokeFunctionRequest request) throws ClientException, ServerException {
        HttpResponse response = null;
        if (request instanceof HttpInvokeFunctionRequest) {
            String form = null;
            if (request.getHeaders() != null && request.getHeaders().containsKey("Content-Type")) {
                form = request.getHeaders().get("Content-Type");
            }
            if (form == null) {
                form = CONTENT_TYPE_APPLICATION_STREAM;
            }
            response = this.client.doAction(request, form, ((HttpInvokeFunctionRequest)request).getMethod());
        } else {
            response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_STREAM, HttpMethod.POST);
        }
        return ResponseFactory.genInvokeFunctionResponse(response);
    }

    public ListOnDemandConfigsResponse listOnDemandConfigs(ListOnDemandConfigsRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        ListOnDemandConfigsResponse listOnDemandConfigsResponse = (ListOnDemandConfigsResponse)GSON.fromJson(new String(response.getContent()), ListOnDemandConfigsResponse.class);
        listOnDemandConfigsResponse.setHeader(response.getHeaders());
        listOnDemandConfigsResponse.setContent(response.getContent());
        listOnDemandConfigsResponse.setStatus(response.getStatus());
        return listOnDemandConfigsResponse;
    }

    public PutOnDemandConfigResponse putOnDemandConfig(PutOnDemandConfigRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT);
        OnDemandConfigMetadata onDemandConfigMetadata = (OnDemandConfigMetadata)GSON.fromJson(new String(response.getContent()), OnDemandConfigMetadata.class);
        PutOnDemandConfigResponse putOnDemandConfigsResponse = new PutOnDemandConfigResponse();
        putOnDemandConfigsResponse.setOnDemandConfigMetadata(onDemandConfigMetadata);
        putOnDemandConfigsResponse.setHeader(response.getHeaders());
        putOnDemandConfigsResponse.setContent(response.getContent());
        putOnDemandConfigsResponse.setStatus(response.getStatus());
        return putOnDemandConfigsResponse;
    }

    public GetOnDemandConfigResponse getOnDemandConfig(GetOnDemandConfigRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        OnDemandConfigMetadata onDemandConfigMetadata = (OnDemandConfigMetadata)GSON.fromJson(new String(response.getContent()), OnDemandConfigMetadata.class);
        GetOnDemandConfigResponse getOnDemandConfigsResponse = new GetOnDemandConfigResponse();
        getOnDemandConfigsResponse.setOnDemandConfigMetadata(onDemandConfigMetadata);
        getOnDemandConfigsResponse.setHeader(response.getHeaders());
        getOnDemandConfigsResponse.setContent(response.getContent());
        getOnDemandConfigsResponse.setStatus(response.getStatus());
        return getOnDemandConfigsResponse;
    }

    public DeleteOnDemandConfigResponse deleteOnDemandConfig(DeleteOnDemandConfigRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        DeleteOnDemandConfigResponse deleteOnDemandConfigsResponse = new DeleteOnDemandConfigResponse();
        deleteOnDemandConfigsResponse.setHeader(response.getHeaders());
        deleteOnDemandConfigsResponse.setContent(response.getContent());
        deleteOnDemandConfigsResponse.setStatus(response.getStatus());
        return deleteOnDemandConfigsResponse;
    }

    public PutFunctionAsyncConfigResponse putFunctionAsyncConfig(PutFunctionAsyncConfigRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.PUT);
        AsyncConfig config = (AsyncConfig)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), AsyncConfig.class);
        PutFunctionAsyncConfigResponse putFunctionAsyncConfigResponse = new PutFunctionAsyncConfigResponse(config);
        putFunctionAsyncConfigResponse.setAsyncConfig(config);
        putFunctionAsyncConfigResponse.setContent(response.getContent());
        putFunctionAsyncConfigResponse.setHeader(response.getHeaders());
        putFunctionAsyncConfigResponse.setStatus(response.getStatus());
        return putFunctionAsyncConfigResponse;
    }

    public GetFunctionAsyncConfigResponse getFunctionAsyncConfig(GetFunctionAsyncConfigRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        AsyncConfig asyncConfig = (AsyncConfig)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), AsyncConfig.class);
        GetFunctionAsyncConfigResponse getFunctionAsyncConfigResponse = new GetFunctionAsyncConfigResponse(asyncConfig);
        getFunctionAsyncConfigResponse.setAsyncConfig(asyncConfig);
        getFunctionAsyncConfigResponse.setHeader(response.getHeaders());
        getFunctionAsyncConfigResponse.setContent(response.getContent());
        getFunctionAsyncConfigResponse.setStatus(response.getStatus());
        return getFunctionAsyncConfigResponse;
    }

    public ListFunctionAsyncConfigsResponse listFunctionAsyncConfigs(ListFunctionAsyncConfigsRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.GET);
        ListFunctionAsyncConfigsResponse listFunctionAsyncConfigsResponse = (ListFunctionAsyncConfigsResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListFunctionAsyncConfigsResponse.class);
        listFunctionAsyncConfigsResponse.setHeader(response.getHeaders());
        listFunctionAsyncConfigsResponse.setContent(response.getContent());
        listFunctionAsyncConfigsResponse.setStatus(response.getStatus());
        return listFunctionAsyncConfigsResponse;
    }

    public DeleteFunctionAsyncConfigResponse deleteFunctionAsyncConfig(DeleteFunctionAsyncConfigRequest request) throws ClientException, ServerException {
        HttpResponse response = this.client.doAction(request, CONTENT_TYPE_APPLICATION_JSON, HttpMethod.DELETE);
        DeleteFunctionAsyncConfigResponse deleteFunctionAsyncConfigResponse = new DeleteFunctionAsyncConfigResponse();
        deleteFunctionAsyncConfigResponse.setHeaders(response.getHeaders());
        deleteFunctionAsyncConfigResponse.setContent(response.getContent());
        deleteFunctionAsyncConfigResponse.setStatus(response.getStatus());
        return deleteFunctionAsyncConfigResponse;
    }

    public String SignURL(SignURLConfig input) throws Exception {
        return input.signURL(this.config.getApiVersion(), this.config.getEndpoint(), this.config.getAccessKeyID(), this.config.getAccessKeySecret(), this.config.getSecurityToken());
    }
}

