/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.config;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.BasicSessionCredentials;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Config {
    private static final String ENDPOINT_FMT = "%s.%s.fc.aliyuncs.com";
    private static final String PROPERTIES_FILE = "fc.properties";
    private static final String REGION_PATTERN = "^[A-Za-z0-9\\-\\_]+$";
    private static final String UID_PATTERN = "^[A-Za-z0-9\\-\\_]+$";
    private String endpoint;
    private String apiVersion = "2016-08-15";
    private String accessKeyID;
    private String accessKeySecret;
    private String securityToken;
    private Boolean isDebug = false;
    private String accountId;
    private String uid;
    private AlibabaCloudCredentialsProvider credsProvider = null;
    private int connectTimeoutMillis = 60000;
    private int connectionRequestTimeoutMillis = 60000;
    private int readTimeoutMillis = 603000;
    private int threadCount = 1;
    private int maxConnectCount = 20;
    private int maxPerRoute = 2;
    private String host;
    private String userAgent;

    private Config(String region, String uid, boolean isHttps) {
        this.checkParam(region, uid);
        this.endpoint = this.buildEndpoint(region, uid, isHttps);
        this.uid = uid;
        this.userAgent = "";
        try {
            Properties props = new Properties();
            InputStream input = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            props.load(input);
            if (props.get("useragent.version") != null) {
                this.userAgent = "java-sdk-" + props.get("useragent.version");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Properties file fc.properties is not found");
        }
    }

    private void checkParam(String region, String uid) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"Region cannot be blank");
        Preconditions.checkArgument((boolean)region.matches("^[A-Za-z0-9\\-\\_]+$"), (Object)"Illegal region");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"Account ID cannot be blank");
        Preconditions.checkArgument((boolean)uid.matches("^[A-Za-z0-9\\-\\_]+$"), (Object)"Illegal Account ID");
    }

    public Config(String region, String uid, String accessKeyID, String accessKeySecret, String securityToken, boolean isHttps) {
        this(region, uid, isHttps);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKeyID) ? 1 : 0) != 0, (Object)"Access key cannot be blank");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKeySecret) ? 1 : 0) != 0, (Object)"Secret key cannot be blank");
        this.accessKeyID = accessKeyID;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
    }

    public Config(String region, String uid, AlibabaCloudCredentialsProvider credsProvider, boolean isHttps) {
        this(region, uid, isHttps);
        this.credsProvider = credsProvider;
    }

    public String getUid() {
        return this.uid;
    }

    public Config setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Config setAccoutId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Config setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Config setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getAccessKeyID() {
        return this.accessKeyID;
    }

    public Config setAccessKeyID(String accessKeyID) {
        this.accessKeyID = accessKeyID;
        return this;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public Config setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
        return this;
    }

    public Boolean getDebug() {
        return this.isDebug;
    }

    public Config setDebug(Boolean debug) {
        this.isDebug = debug;
        return this;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public Config setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public int getConnectionRequestTimeoutMillis() {
        return this.connectionRequestTimeoutMillis;
    }

    public Config setConnectionRequestTimeoutMillis(int connectionRequestTimeoutMillis) {
        this.connectionRequestTimeoutMillis = connectionRequestTimeoutMillis;
        return this;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public Config setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public Config setHost(String host) {
        this.host = host;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public Config setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        return this;
    }

    private String buildEndpoint(String region, String uid, boolean isHttps) {
        String endpoint = String.format(ENDPOINT_FMT, uid, region);
        String protocol = isHttps ? "https" : "http";
        return protocol + "://" + endpoint;
    }

    public void refreshCredentials() {
        if (this.credsProvider == null) {
            return;
        }
        try {
            AlibabaCloudCredentials creds = this.credsProvider.getCredentials();
            this.accessKeyID = creds.getAccessKeyId();
            this.accessKeySecret = creds.getAccessKeySecret();
            if (creds instanceof BasicSessionCredentials) {
                this.securityToken = ((BasicSessionCredentials)creds).getSessionToken();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AlibabaCloudCredentialsProvider getCredsProvider() {
        return this.credsProvider;
    }

    public void setCredsProvider(AlibabaCloudCredentialsProvider credsProvider) {
        this.credsProvider = credsProvider;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getMaxConnectCount() {
        return this.maxConnectCount;
    }

    public void setMaxConnectCount(int maxConnectCount) {
        this.maxConnectCount = maxConnectCount;
    }

    public int getMaxPerRoute() {
        return this.maxPerRoute;
    }

    public void setMaxPerRoute(int maxPerRoute) {
        this.maxPerRoute = maxPerRoute;
    }
}

