/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.core;

import com.aliyuncs.fc.client.FcCallback;
import com.aliyuncs.fc.core.AbstractWatchableCallback;
import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.exceptions.ServerException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.http.HttpResponse;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import org.apache.http.concurrent.FutureCallback;

public class AsyncCompletion<Req extends HttpRequest, Res extends HttpResponse>
extends AbstractWatchableCallback<Req, Res>
implements FutureCallback<Res> {
    private Req request;
    private ExecutorService executor;

    public AsyncCompletion(Req request, ExecutorService executor) {
        this.request = request;
        this.executor = executor;
    }

    public void completed(Res res) {
        this.onCompleted(this.request, res);
    }

    public void failed(Exception ex) {
        Exception e;
        ex.printStackTrace();
        if (ex instanceof ClientException) {
            e = ex;
        } else if (ex instanceof ServerException) {
            e = ex;
        } else if (ex instanceof SocketTimeoutException) {
            e = new ClientException("SDK.ServerUnreachable", "SocketTimeoutException has occurred on a socket read or accept." + ex.toString());
        } else if (ex instanceof InvalidKeyException) {
            e = new ClientException("SDK.InvalidAccessSecret", "Speicified access secret is not valid.");
        } else if (ex instanceof IOException) {
            e = new ClientException("SDK.ServerUnreachable", "Server unreachable: " + ex.toString());
        } else if (ex instanceof NoSuchAlgorithmException) {
            e = new ClientException("SDK.InvalidMD5Algorithm", "MD5 hash is not supported by client side.");
        } else {
            if (ex instanceof URISyntaxException) {
                throw new ClientException("SDK.InvalidURL", "url is not valid: " + ex.getMessage());
            }
            e = new ClientException("SDK.UnknownError", ex.getMessage(), ex.getCause());
        }
        this.onFailed(this.request, e);
    }

    public void cancelled() {
    }

    @Override
    public void onCompleted(Req req, Res res) {
        for (final FcCallback cb : this.callbacks) {
            this.executor.submit(new Runnable((HttpRequest)req, (HttpResponse)res){
                final /* synthetic */ HttpRequest val$req;
                final /* synthetic */ HttpResponse val$res;
                {
                    this.val$req = httpRequest;
                    this.val$res = httpResponse;
                }

                @Override
                public void run() {
                    cb.onCompleted(this.val$req, this.val$res);
                }
            });
        }
    }

    @Override
    public void onFailed(Req req, Exception exception) {
        for (final FcCallback cb : this.callbacks) {
            this.executor.submit(new Runnable((HttpRequest)req, exception){
                final /* synthetic */ HttpRequest val$req;
                final /* synthetic */ Exception val$exception;
                {
                    this.val$req = httpRequest;
                    this.val$exception = exception;
                }

                @Override
                public void run() {
                    cb.onFailed(this.val$req, this.val$exception);
                }
            });
        }
    }
}

