/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.core;

import com.aliyuncs.fc.client.FcCallback;
import com.aliyuncs.fc.core.AbstractWatchableCallback;
import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.exceptions.ServerException;
import com.google.common.base.Preconditions;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureCallback<Req, Res>
extends AbstractWatchableCallback<Req, Res>
implements Future<Res> {
    private boolean completed = false;
    private Res result;
    private Exception ex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted(Req request, Res result) {
        FutureCallback futureCallback = this;
        synchronized (futureCallback) {
            if (this.completed) {
                throw new IllegalStateException("completed() must not be invoked twice.");
            }
            this.completed = true;
            this.result = result;
            this.notifyAll();
        }
        for (FcCallback callback : this.callbacks) {
            callback.onCompleted(request, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailed(Req request, Exception ex) {
        FutureCallback futureCallback = this;
        synchronized (futureCallback) {
            if (this.completed) {
                throw new IllegalStateException("completed() must not be invoked twice.");
            }
            this.completed = true;
            this.ex = ex;
            this.notifyAll();
        }
        for (FcCallback callback : this.callbacks) {
            callback.onFailed(request, ex);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        FutureCallback futureCallback = this;
        synchronized (futureCallback) {
            return this.completed;
        }
    }

    @Override
    public synchronized Res get() throws InterruptedException {
        while (!this.completed) {
            this.wait();
        }
        return this.getResultWithoutLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Res get(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"Time unit should not be null");
        long endTime = System.currentTimeMillis() + unit.toMillis(timeout);
        FutureCallback futureCallback = this;
        synchronized (futureCallback) {
            while (!this.completed) {
                long waitTime = endTime - System.currentTimeMillis();
                if (waitTime <= 0L) {
                    throw new TimeoutException();
                }
                this.wait(waitTime);
            }
            return this.getResultWithoutLock();
        }
    }

    private Res getResultWithoutLock() throws ClientException, ServerException {
        if (this.ex instanceof ServerException) {
            throw (ServerException)this.ex;
        }
        if (this.ex instanceof ClientException) {
            throw (ClientException)this.ex;
        }
        return this.result;
    }
}

