/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.exceptions;

import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class ClientException
extends RuntimeException {
    private static final long serialVersionUID = 534996425110290578L;
    private Map<String, String> headers;
    private int statusCode;
    @SerializedName(value="ErrorCode")
    private String errorCode;
    @SerializedName(value="ErrorMessage")
    private String errorMessage;
    private String requestId;

    public ClientException(String errCode, String errMsg, String requestId) {
        this(errCode, errMsg);
        this.requestId = requestId;
    }

    public ClientException(String errCode, String errMsg) {
        super(errCode + " : " + errMsg);
        this.errorCode = errCode;
        this.errorMessage = errMsg;
    }

    public ClientException(String errCode, String errMsg, Throwable cause) {
        super(errCode + " : " + errMsg, cause);
        this.errorCode = errCode;
        this.errorMessage = errMsg;
    }

    public ClientException(String message) {
        super(message);
    }

    public ClientException(Throwable cause) {
        super(cause);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ClientException setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ClientException setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public ClientException setErrCode(String errCode) {
        this.errorCode = errCode;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ClientException setErrMsg(String errMsg) {
        this.errorMessage = errMsg;
        return this;
    }

    @Override
    public String getMessage() {
        if (this.requestId == null) {
            return super.getMessage();
        }
        return "RequestId: " + this.requestId + ", ErrorCode: " + this.errorCode + ", ErrorMessage: " + this.errorMessage;
    }
}

