/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.http;

import com.aliyuncs.fc.exceptions.ClientException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class HttpRequest {
    protected Map<String, String> headers = new HashMap<String, String>();

    public abstract String getPath();

    public abstract void validate() throws ClientException;

    public HttpURLConnection getHttpConnection(String urls, String method) throws IOException {
        String strUrl = urls;
        if (null == strUrl || null == method) {
            return null;
        }
        URL url = new URL(strUrl);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod(method);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setUseCaches(false);
        httpConn.setConnectTimeout(60000);
        httpConn.setReadTimeout(603000);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpConn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return httpConn;
    }

    public void setHeader(String key, String value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Header key cannot be blank");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)"Header value cannot be blank");
        this.headers.put(key, value);
    }

    public byte[] getPayload() {
        return null;
    }

    public Map<String, String> getQueryParams() {
        return null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

