/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.http;

import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.HttpMethod;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpResponse {
    private int status;
    private byte[] content;
    private Map<String, String> headers;

    public void setHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getHeader(String name) {
        String value = this.headers.get(name);
        if (null == value) {
            value = this.headers.get(name.toLowerCase());
        }
        return value;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    private static byte[] readContent(InputStream content) throws IOException {
        int read;
        if (content == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((read = content.read(buff)) != -1) {
            outputStream.write(buff, 0, read);
        }
        return outputStream.toByteArray();
    }

    private static void parseHttpConn(HttpResponse response, HttpURLConnection httpConn, InputStream content) throws IOException {
        byte[] buff = HttpResponse.readContent(content);
        response.setStatus(httpConn.getResponseCode());
        Map<String, List<String>> headers = httpConn.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (null == key) continue;
            List<String> values = entry.getValue();
            StringBuilder builder = new StringBuilder(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                builder.append(",");
                builder.append(values.get(i));
            }
            response.setHeader(key, builder.toString());
        }
        response.setContent(buff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse getResponse(String urls, HttpRequest request, HttpMethod method, int connectTimeoutMillis, int readTimeoutMillis) throws IOException {
        OutputStream out = null;
        InputStream content = null;
        HttpResponse response = null;
        HttpURLConnection httpConn = request.getHttpConnection(urls, method.name());
        httpConn.setConnectTimeout(connectTimeoutMillis);
        httpConn.setReadTimeout(readTimeoutMillis);
        try {
            httpConn.connect();
            if (null != request.getPayload() && request.getPayload().length > 0) {
                out = httpConn.getOutputStream();
                out.write(request.getPayload());
            }
            content = httpConn.getInputStream();
            response = new HttpResponse();
            HttpResponse.parseHttpConn(response, httpConn, content);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            content = httpConn.getErrorStream();
            response = new HttpResponse();
            HttpResponse.parseHttpConn(response, httpConn, content);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (content != null) {
                content.close();
            }
            httpConn.disconnect();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isSuccess() {
        return 200 <= this.status && 300 > this.status;
    }

    public String getRequestId() {
        return this.headers.get("X-Fc-Request-Id");
    }

    public String getEtag() {
        return this.headers.get("Etag");
    }

    public String toString() {
        return "HttpResponse{status=" + this.status + ", content=" + Arrays.toString(this.content) + ", headers=" + this.headers + '}';
    }
}

