/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.google.common.base.Strings;
import java.util.Map;

public class BaseOnDemandConfigRequest
extends HttpRequest {
    protected String serviceName;
    protected String functionName;
    protected String qualifier;

    public BaseOnDemandConfigRequest() {
    }

    public BaseOnDemandConfigRequest(String serviceName, String qualifier, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
        this.qualifier = qualifier;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getQualifierName() {
        return this.qualifier;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    public Map<String, String> getHeader() {
        return null;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s.%s/functions/%s/on-demand-config", "2016-08-15", this.serviceName, this.qualifier, this.functionName);
    }

    @Override
    public byte[] getPayload() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.qualifier)) {
            throw new ClientException("Qualifier cannot be blank");
        }
    }
}

