/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.CreateAliasResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class CreateAliasRequest
extends HttpRequest {
    private final String serviceName;
    @SerializedName(value="aliasName")
    private final String aliasName;
    @SerializedName(value="versionId")
    private final String versionId;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="additionalVersionWeight")
    private Map<String, Float> additionalVersionWeight;

    public CreateAliasRequest(String serviceName, String aliasName, String versionId) {
        this.serviceName = serviceName;
        this.aliasName = aliasName;
        this.versionId = versionId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateAliasRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Float> getAdditionalVersionWeight() {
        return this.additionalVersionWeight;
    }

    public CreateAliasRequest setAdditionalVersionWeight(Map<String, Float> additionalVersionWeight) {
        this.additionalVersionWeight = additionalVersionWeight;
        return this;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/aliases", "2016-08-15", this.serviceName);
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    public Class<CreateAliasResponse> getResponseClass() {
        return CreateAliasResponse.class;
    }
}

