/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.FormatType;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.Code;
import com.aliyuncs.fc.model.CustomContainerConfig;
import com.aliyuncs.fc.response.CreateFunctionResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class CreateFunctionRequest
extends HttpRequest {
    private final transient String serviceName;
    @SerializedName(value="functionName")
    private String functionName;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="runtime")
    private String runtime;
    @SerializedName(value="handler")
    private String handler;
    @SerializedName(value="initializer")
    private String initializer;
    @SerializedName(value="timeout")
    private Integer timeout;
    @SerializedName(value="initializationTimeout")
    private Integer initializationTimeout;
    @SerializedName(value="memorySize")
    private Integer memorySize;
    @SerializedName(value="code")
    private Code code;
    @SerializedName(value="environmentVariables")
    private Map<String, String> environmentVariables;
    @SerializedName(value="instanceConcurrency")
    private Integer instanceConcurrency;
    @SerializedName(value="instanceType")
    private String instanceType;
    @SerializedName(value="customContainerConfig")
    private CustomContainerConfig customContainerConfig;
    @SerializedName(value="caPort")
    private Integer caPort;

    public CreateFunctionRequest(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public CreateFunctionRequest setCode(Code code) {
        this.code = code;
        return this;
    }

    public Code getCode() {
        return this.code;
    }

    public CreateFunctionRequest setFunctionName(String functionName) {
        this.functionName = functionName;
        return this;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public CreateFunctionRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateFunctionRequest setRuntime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public CreateFunctionRequest setHandler(String handler) {
        this.handler = handler;
        return this;
    }

    public String getHandler() {
        return this.handler;
    }

    public CreateFunctionRequest setInitializer(String initializer) {
        this.initializer = initializer;
        return this;
    }

    public String getInitializer() {
        return this.initializer;
    }

    public CreateFunctionRequest setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public CreateFunctionRequest setInitializationTimeout(Integer initializationTimeout) {
        this.initializationTimeout = initializationTimeout;
        return this;
    }

    public Integer getInitializationTimeout() {
        return this.initializationTimeout;
    }

    public CreateFunctionRequest setMemorySize(Integer memorySize) {
        this.memorySize = memorySize;
        return this;
    }

    public Integer getMemorySize() {
        return this.memorySize;
    }

    public CreateFunctionRequest setInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public CreateFunctionRequest setCustomContainerConfig(CustomContainerConfig customContainerConfig) {
        this.customContainerConfig = customContainerConfig;
        return this;
    }

    public CustomContainerConfig getCustomContainerConfig() {
        return this.customContainerConfig;
    }

    public CreateFunctionRequest setCAPort(Integer caPort) {
        this.caPort = caPort;
        return this;
    }

    public Integer getCAPort() {
        return this.caPort;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/functions", "2016-08-15", this.serviceName);
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    public FormatType getFormat() {
        return FormatType.JSON;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    public Class<CreateFunctionResponse> getResponseClass() {
        return CreateFunctionResponse.class;
    }

    public Integer getInstanceConcurrency() {
        return this.instanceConcurrency;
    }

    public void setInstanceConcurrency(Integer instanceConcurrency) {
        this.instanceConcurrency = instanceConcurrency;
    }
}

