/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.CreateTriggerResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class CreateTriggerRequest
extends HttpRequest {
    private final transient String serviceName;
    private final transient String functionName;
    @SerializedName(value="triggerName")
    private String triggerName;
    @SerializedName(value="sourceArn")
    private String sourceArn;
    @SerializedName(value="triggerType")
    private String triggerType;
    @SerializedName(value="invocationRole")
    private String invocationRole;
    @SerializedName(value="triggerConfig")
    private Object triggerConfig;
    @SerializedName(value="qualifier")
    private String qualifier;

    public CreateTriggerRequest(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public CreateTriggerRequest setTriggerName(String triggerName) {
        this.triggerName = triggerName;
        return this;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public CreateTriggerRequest setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
        return this;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public CreateTriggerRequest setTriggerType(String triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    public String getTriggerType() {
        return this.triggerType;
    }

    public CreateTriggerRequest setInvocationRole(String invocationRole) {
        this.invocationRole = invocationRole;
        return this;
    }

    public String getInvocationRole() {
        return this.invocationRole;
    }

    public CreateTriggerRequest setTriggerConfig(Object triggerConfig) {
        this.triggerConfig = triggerConfig;
        return this;
    }

    public Object getTriggerConfig() {
        return this.triggerConfig;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/functions/%s/triggers", "2016-08-15", this.serviceName, this.functionName);
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    public Class<CreateTriggerResponse> getResponseClass() {
        return CreateTriggerResponse.class;
    }
}

