/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.DeleteAliasResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class DeleteAliasRequest
extends HttpRequest {
    private final transient String serviceName;
    private final transient String aliasName;
    private transient String ifMatch;

    public DeleteAliasRequest(String serviceName, String aliasName) {
        this.serviceName = serviceName;
        this.aliasName = aliasName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/aliases/%s", "2016-08-15", this.serviceName, this.aliasName);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.ifMatch != null && this.ifMatch.length() < 0) {
            this.headers.put("If-Match", this.ifMatch);
        }
        return this.headers;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.aliasName)) {
            throw new ClientException("Alias name cannot be blank");
        }
    }

    public Class<DeleteAliasResponse> getResponseClass() {
        return DeleteAliasResponse.class;
    }
}

