/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.DeleteFunctionResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class DeleteFunctionRequest
extends HttpRequest {
    private final String serviceName;
    private final String functionName;
    private transient String ifMatch;

    public DeleteFunctionRequest(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public DeleteFunctionRequest setIfMatch(String IfMatch) {
        this.ifMatch = IfMatch;
        return this;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/functions/%s", "2016-08-15", this.serviceName, this.functionName);
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public Map<String, String> getHeaders() {
        if (!Strings.isNullOrEmpty((String)this.ifMatch)) {
            this.headers.put("If-Match", this.ifMatch);
        }
        return this.headers;
    }

    @Override
    public byte[] getPayload() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    public Class<DeleteFunctionResponse> getResponseClass() {
        return DeleteFunctionResponse.class;
    }
}

