/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.DeleteServiceResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class DeleteServiceRequest
extends HttpRequest {
    private final String serviceName;
    private transient String ifMatch;

    public DeleteServiceRequest(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public DeleteServiceRequest setIfMath(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s", "2016-08-15", this.serviceName);
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public Map<String, String> getHeaders() {
        if (!Strings.isNullOrEmpty((String)this.ifMatch)) {
            this.headers.put("If-Match", this.ifMatch);
        }
        return this.headers;
    }

    @Override
    public byte[] getPayload() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    public Class<DeleteServiceResponse> getResponseClass() {
        return DeleteServiceResponse.class;
    }
}

