/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.DeleteTriggerResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class DeleteTriggerRequest
extends HttpRequest {
    private final String serviceName;
    private final String functionName;
    private final String triggerName;
    private transient String ifMatch;

    public DeleteTriggerRequest(String serviceName, String functionName, String triggerName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
        this.triggerName = triggerName;
    }

    public DeleteTriggerRequest setIfMatch(String ifMath) {
        this.ifMatch = ifMath;
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/functions/%s/triggers/%s", "2016-08-15", this.serviceName, this.functionName, this.triggerName);
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public Map<String, String> getHeaders() {
        if (!Strings.isNullOrEmpty((String)this.ifMatch)) {
            this.headers.put("If-Match", this.ifMatch);
        }
        return this.headers;
    }

    @Override
    public byte[] getPayload() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.triggerName)) {
            throw new ClientException("Trigger name cannot be blank");
        }
    }

    public Class<DeleteTriggerResponse> getResponseClass() {
        return DeleteTriggerResponse.class;
    }
}

