/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.DeleteFunctionResponse;
import com.google.common.base.Strings;

public class DeleteVersionRequest
extends HttpRequest {
    private final String serviceName;
    private final String versionID;

    public DeleteVersionRequest(String serviceName, String versionID) {
        this.serviceName = serviceName;
        this.versionID = versionID;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getVersionID() {
        return this.versionID;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/versions/%s", "2016-08-15", this.serviceName, this.versionID);
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.versionID)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    public Class<DeleteFunctionResponse> getResponseClass() {
        return DeleteFunctionResponse.class;
    }
}

