/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.GetAliasResponse;
import com.google.common.base.Strings;

public class GetAliasRequest
extends HttpRequest {
    private final transient String serviceName;
    private final transient String aliasName;

    public GetAliasRequest(String serviceName, String aliasName) {
        this.serviceName = serviceName;
        this.aliasName = aliasName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/aliases/%s", "2016-08-15", this.serviceName, this.aliasName);
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.aliasName)) {
            throw new ClientException("Alias name cannot be blank");
        }
    }

    public Class<GetAliasResponse> getResponseClass() {
        return GetAliasResponse.class;
    }
}

