/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.GetFunctionResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class GetFunctionRequest
extends HttpRequest {
    private final String serviceName;
    private final String functionName;
    private String qualifier;

    public GetFunctionRequest(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public GetFunctionRequest setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    @Override
    public String getPath() {
        if (Strings.isNullOrEmpty((String)this.qualifier)) {
            return String.format("/%s/services/%s/functions/%s", "2016-08-15", this.serviceName, this.functionName);
        }
        return String.format("/%s/services/%s.%s/functions/%s", "2016-08-15", this.serviceName, this.qualifier, this.functionName);
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public byte[] getPayload() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    public Class<GetFunctionResponse> getResponseClass() {
        return GetFunctionResponse.class;
    }
}

