/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.GetProvisionConfigResponse;
import com.google.common.base.Strings;

public class GetProvisionConfigRequest
extends HttpRequest {
    private final transient String serviceName;
    private final transient String qualifier;
    private final transient String functionName;

    public GetProvisionConfigRequest(String serviceName, String qualifier, String functionName) {
        this.serviceName = serviceName;
        this.qualifier = qualifier;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s.%s/functions/%s/provision-config", "2016-08-15", this.serviceName, this.qualifier, this.functionName);
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.qualifier)) {
            throw new ClientException("Qualifier cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    public Class<GetProvisionConfigResponse> getResponseClass() {
        return GetProvisionConfigResponse.class;
    }
}

